package com.biz.crm.dms.business.costpool.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description 费用吃摘要枚举 上账/使用
 * @Author YangWei
 * @Date Created in 2022/3/18 下午3:33
 */
public enum CostPoolSummaryEnum {
  /**
   * 期初
   */
  BEGIN("opening_balance", "BEGIN", "期初", "1"),

  /**
   * 上账
   */
  ON("keep_books", "ON", "上账", "2"),
  /**
   * 使用
   */
  USE("used", "USE", "使用", "3"),
  /**
   * 期末
   */
  END("closing_balance", "END", "期末", "4"),
  /**
   * 总额度
   */
  TOTAL("total_amount", "TOTAL", "总额度", "5"),
  
  /**
   * 占用
   */
  OCCUPY("occupy", "OCCUPY", "占用", "6"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CostPoolSummaryEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 CapitalAdjustTypeEnum
   *
   * @param key
   * @return
   */
  public static CostPoolSummaryEnum getByKey(String key) {
    return Arrays.stream(CostPoolSummaryEnum.values())
        .filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
