package com.biz.crm.dms.business.costpool.sdk.model;

import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 费用池类型模型
 *
 * @author songjingen
 */
@Data
@ApiModel(value = "费用池类型模型")
public class CostPoolModel {

  /**
   * 费用池中文名称
   * 具体费用池实现该方法，告知本费用池的中文名（注意，具体的费用池中，设定的该信息不能重复）
   *
   * @return
   */
  private String name;

  /**
   * 费用池key
   * 具体费用池实现该方法，告知本费用池的英文key（注意，具体的费用池中，设定的该信息不能重复）
   *
   * @return
   */
  private String key;
}
