package com.biz.crm.dms.business.costpool.sdk.service;

import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 根据摘要统计不同操作类型的金额
 *
 * @author songjingen
 */
public interface CostPoolAmountStatisticsVoService {

  /**
   * 按照客户编码和日期范围统计，以mapKey为key，统计的金额集合为value
   *
   * @param customerCode 客户编码
   * @param beginDate    开始时间(年月日 时分秒)
   * @param endDate      结束时间(年月日 时分秒)
   * @param mapKey       map的key
   * @return 以mapKey为key，统计的金额集合为value
   */
  Map<String, List<CostPoolAmountStatisticsVo>> handleAmountStatisticsByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate, String mapKey);

}
