package com.biz.crm.dms.business.costpool.sdk.service;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.model.CostPoolModel;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 费用池通用service服务层
 *
 * @author songjingen
 */
public interface CostPoolVoService {

  /**
   * 触发请求费用池数据
   * 根据poolType去查找对应的费用池
   *
   * @param costPoolDto 请求对象
   */
  List<CostPoolVo> handleRequestCostPoolVos(CostPoolDto costPoolDto);

  /**
   * 触发调整费用池
   * 根据poolType去调整对应的费用池
   *
   * @param jsonArray 入参json数组
   */
  void handleAdjust(JSONArray jsonArray);

  /**
   * 查询费所有费用池模型
   *
   * @return
   */
  List<CostPoolModel> findCostPoolModel();

  /**
   * 根据用户编码查询余额
   *
   * @param customerCode
   * @return
   */
  Map<String, BigDecimal> findUsableAmountByCustomerCodeStuMap(String customerCode);
}
