package com.biz.crm.dms.business.costpool.sdk.strategy;

/**
 * 费用池注册器，所有费用池模块都需要实现此注册器
 *
 * @author songjingen
 */
public interface CostPoolRegister {

  /**
   * 费用池中文名称
   * 具体费用池实现该方法，告知本费用池的中文名（注意，具体的费用池中，设定的该信息不能重复）
   *
   * @return
   */
  String getName();

  /**
   * 费用池key
   * 具体费用池实现该方法，告知本费用池的英文key（注意，具体的费用池中，设定的该信息不能重复）
   *
   * @return
   */
  String getKey();
}
