package com.biz.crm.dms.business.costpool.sdk.vo;

import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 费用池按照摘要操作类型统计金额vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用池按照操作类型统计金额vo")
public class CostPoolAmountStatisticsVo {

  /**
   * 费用池类型
   * {@link CostPoolVoService#findCostPoolModel()}
   *
   * @see CostPoolRegister#getKey()
   */
  @ApiModelProperty("费用池类型")
  private String poolType;

  /**
   * 摘要
   *
   * @see com.biz.crm.dms.business.costpool.sdk.enums.CostPoolSummaryEnum#getDictCode()
   */
  @ApiModelProperty("摘要")
  private String summary;

  /**
   * 总金额
   */
  @ApiModelProperty("总金额")
  private BigDecimal totalAmount;
}
