package com.biz.crm.dms.business.costpool.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池基础抽象vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用池基础抽象vo")
public abstract class CostPoolVo implements Serializable {

  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String customerCode;
  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String customerName;
  /**
   * 总金额（数量）
   */
  @ApiModelProperty(value = "总金额")
  private BigDecimal totalAmount;
  /**
   * 冻结金额（数量）
   */
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal freezeAmount;
  /**
   * 已使用金额（数量）
   */
  @ApiModelProperty(value = "已使用金额")
  private BigDecimal hasUseAmount;
  /**
   * 剩余可使用金额（数量）
   */
  @ApiModelProperty(value = "剩余可使用金额")
  private BigDecimal usableAmount;


}
