package com.biz.crm.dms.business.costpool.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池基础dto
 *
 * @author songjingen
 */
@Data
@ApiModel(value = "费用池基础dto")
public class CostPoolDto implements Serializable {
  /**
   * 费用池类型，目前存在一下四种：
   * 资金
   * 信用
   * 货补
   * 折扣
   * 通过CostPoolRegister注册器去获取类型key
   */
  @ApiModelProperty(value = "费用池类型")
  private String poolType;
  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String customerCode;
  /**
   * 来源描述
   */
  @ApiModelProperty(value = "来源描述")
  private String fromDesc;
  /**
   * 来源编码
   */
  @ApiModelProperty(value = "来源编码")
  private String fromCode;
  /**
   * 金额
   */
  @ApiModelProperty(value = "金额")
  private BigDecimal amount;
  /**
   * 货补费用池编号集合（只有货补池使用）
   */
  @ApiModelProperty(value = "货补费用池编号集合（只有货补池使用）")
  private List<String> poolCodeList;
}
