package com.biz.crm.dms.business.costpool.sdk.observer;


import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;

import java.util.Date;
import java.util.List;

/**
 * 根据摘要统计不同操作类型的金额观察者
 *
 * @author songjingen
 */
public interface CostPoolAmountStatisticsObserver {

  /**
   * 按照摘要统计的金额为集合
   *
   * @param customerCode 客户编码
   * @param beginDate    开始时间(年月日 时分秒)
   * @param endDate      结束时间(年月日 时分秒)
   * @return 按照摘要统计的金额为集合
   */
  List<CostPoolAmountStatisticsVo> findAmountStatisticsVoByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate);

}
