package com.biz.crm.dms.business.costpool.sdk.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;

import java.util.List;

/**
 * 费用池观察者
 * 此观察者需要所有的费用池模块进行实现
 *
 * @author songjingen
 */
public interface CostPoolStrategy {

  /**
   * 此方法是获取费用池类型注册的key，所有子模块都需要实现此接口，并保证全局唯一
   *
   * @return
   */
  String getPoolTypeRegisterKey();

  /**
   * 此方法是获取费用池的资金信息
   *
   * @param costPoolDto 费用池基础dto
   * @return
   */
  List<CostPoolVo> onRequestCostPoolVos(CostPoolDto costPoolDto);

  /**
   * 此方法是触发调整费用池
   *
   * @param jsonObject 费用池入参json对象(入参必须包括CostPoolDto对象中属性)
   * @return
   */
  void onHandleAdjust(JSONObject jsonObject);

}
