package com.biz.crm.dms.business.delivery.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryDetailVo;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * 获取可选的订单及发货单信息
 *
 * @author pengxi
 */
@RestController
@RequestMapping("/v1/delivery/deliveryDetail")
@Slf4j
@Api(tags = "发货单模块：DeliveryDetailVo：获取可选的订单及发货单信息")
public class DeliveryDetailVoController {

  @Autowired(required = false)
  private DeliveryDetailVoService deliveryDetailVoService;
  
  /**
   * 获取可选的订单及发货单信息
   */
  @ApiOperation(value = "获取可选的订单及发货单信息")
  @GetMapping("findDeliveryDetails")
  public Result<Page<DeliveryDetailVo>> findDeliveryDetails(@PageableDefault(50) Pageable pageable, @ApiParam(name = "deliveryDto", value = "分页Dto") DeliveryUnshippedPageDto dto) {
    try {
      // 只查询待发货、部分发货的订单及发货单信息
      List<String> orderStatusList = Lists.newLinkedList();
      orderStatusList.add(OrderStatusEnum.WAIT_SHIPPED.getDictCode());
      orderStatusList.add(OrderStatusEnum.PART_SHIPPED.getDictCode());
      dto.setOrderStatus(orderStatusList);
      Page<DeliveryDetailVo> result = this.deliveryDetailVoService.findOptionalOrderAndDeliveryDetails(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据发货单编码获取发货单详细信息
   */
  @ApiOperation(value = "根据发货单编码获取发货单详细信息")
  @GetMapping("findDetailByDeliveryCodes")
  public Result<List<DeliveryDetailVo>> findDetailByDeliveryCodes(@RequestParam("deliveryCodes") Set<String> deliveryCodes) {
    try {
      List<DeliveryDetailVo> result = this.deliveryDetailVoService.findDetailByDeliveryCodes(deliveryCodes);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
