package com.biz.crm.dms.business.delivery.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryEntity;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryDto;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryVo;
import org.apache.ibatis.annotations.Param;

/**
 * 发货单表的mybatis-plus接口类 {@link DeliveryEntity}
 *
 * @author pengxi
 * @date 2021/12/30
 */
public interface DeliveryMapper extends BaseMapper<DeliveryEntity> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<DeliveryVo> findByConditions(Page<DeliveryDto> page, @Param("dto") DeliveryDto dto);

}

