package com.biz.crm.dms.business.delivery.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryAttachmentEntity;
import com.biz.crm.dms.business.delivery.local.mapper.DeliveryAttachmentMapper;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 发货单附件表的数据库访问类 {@link DeliveryAttachmentEntity}
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Component
public class DeliveryAttachmentRepository extends ServiceImpl<DeliveryAttachmentMapper, DeliveryAttachmentEntity> {

  /**
   * 根据id集合获取详情集合
   *
   * @param tenantCode 租户编码
   * @param deliveryCodes 发货单编码集合
   * @return List<DeliveryEntity>
   */
  public List<DeliveryAttachmentEntity> findByDeliveryCodes(String tenantCode, Set<String> deliveryCodes) {
    return this.lambdaQuery()
        .eq(DeliveryAttachmentEntity::getTenantCode, tenantCode)
        .in(DeliveryAttachmentEntity::getDeliveryCode, deliveryCodes)
        .list();
  }
  
  /**
   * 根据发货单编码删除
   *
   * @param tenantCode 租户编码
   * @param deliveryCodes 发货单编码集合
   */
  public void deleteByDeliveryCodes(String tenantCode, Set<String> deliveryCodes) {
    this.lambdaUpdate()
        .eq(DeliveryAttachmentEntity::getTenantCode, tenantCode)
        .in(DeliveryAttachmentEntity::getDeliveryCode, deliveryCodes)
        .remove();
  }
}
