package com.biz.crm.dms.business.delivery.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryDetailDeductEntity;
import com.biz.crm.dms.business.delivery.local.mapper.DeliveryDetailDeductMapper;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 发货单明细行上该扣项目的数据库访问类 {@link DeliveryDetailDeductEntity}
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Component
public class DeliveryDetailDeductRepository extends ServiceImpl<DeliveryDetailDeductMapper, DeliveryDetailDeductEntity> {

  /**
   * 根据订单编码集合获取详情集合
   *
   * @param orderCodes 发货单编码集合
   * @return List<DeliveryEntity>
   */
  public List<DeliveryDetailDeductEntity> findByOrderCodes(Collection<String> orderCodes) {
    return this.lambdaQuery()
        .in(DeliveryDetailDeductEntity::getOrderCode, orderCodes)
        .list();
  }

  /**
   * 根据发货单编码集合获取详情集合
   *
   * @param deliveryCodes 发货单编码集合
   * @return List<DeliveryEntity>
   */
  public List<DeliveryDetailDeductEntity> findByDeliveryCodes(Collection<String> deliveryCodes) {
    return this.lambdaQuery()
        .in(DeliveryDetailDeductEntity::getDeliveryCode, deliveryCodes)
        .list();
  }

  /**
   * 根据发货单编码删除
   *
   * @param tenantCode 租户编码
   * @param deliveryCodes 发货单编码集合
   */
  public void deleteByDeliveryCodes(String tenantCode, Set<String> deliveryCodes) {
    this.lambdaUpdate()
        .eq(DeliveryDetailDeductEntity::getTenantCode, tenantCode)
        .in(DeliveryDetailDeductEntity::getDeliveryCode, deliveryCodes)
        .remove();
  }
}
