package com.biz.crm.dms.business.delivery.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryUnshippedVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryUnshippedVo;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 *
 * 订单优惠政策预览相关的http接口
 *
 * @author hefan
 * @since 2022-01-08 15:13:04
 */
@RestController
@RequestMapping("/v1/delivery/deliveryUnshippedVo")
@Slf4j
@Api(tags = "发货单模块：DeliveryUnshippedVo：未发货（包含部分待发货）订单信息")
public class DeliveryUnshippedVoController {

  @Autowired(required = false)
  private DeliveryUnshippedVoService deliveryUnshippedVoService;

  /**
   * 未发货（包含部分待发货）订单信息分页接口
   */
  @ApiOperation(value = "未发货（包含部分待发货）订单信息分页接口")
  @GetMapping("findByOrderUnshippedPageDto")
  public Result<Page<DeliveryUnshippedVo>> findByOrderUnshippedPageDto(@PageableDefault(50) Pageable pageable, @ApiParam(name = "order", value = "未发货（包含部分待发货）订单信息分页接口") DeliveryUnshippedPageDto dto) {
    try {
      // 只查询待发货、部分发货的订单及发货单信息
      List<String> orderStatusList = Lists.newLinkedList();
      orderStatusList.add(OrderStatusEnum.WAIT_SHIPPED.getDictCode());
      orderStatusList.add(OrderStatusEnum.PART_SHIPPED.getDictCode());
      dto.setOrderStatus(orderStatusList);
      Page<DeliveryUnshippedVo> result = this.deliveryUnshippedVoService.findByOrderUnshippedPageDto(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据订单状态查询订单信息分页接口
   */
  @ApiOperation(value = "根据订单状态查询订单信息分页接口")
  @GetMapping("findByOrderStatusPageDto")
  public Result<Page<DeliveryUnshippedVo>> findByOrderStatusPageDto(@PageableDefault(50) Pageable pageable, @ApiParam(name = "order", value = "根据订单状态查询订单信息分页接口") DeliveryUnshippedPageDto dto) {
    try {
      Validate.notEmpty(dto.getOrderStatus(), "订单状态条件必传！");
      Page<DeliveryUnshippedVo> result = this.deliveryUnshippedVoService.findByOrderUnshippedPageDto(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
