package com.biz.crm.dms.business.delivery.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 发货单附件实体类
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DeliveryAttachmentEntity", description = "发货单附件实体类")
@Entity
@TableName("dms_delivery_attachment")
@Table(name = "dms_delivery_attachment",
    indexes = {@Index(columnList = "tenant_code ,delivery_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_delivery_attachment", comment = "发货单附件实体类")
public class DeliveryAttachmentEntity extends FileEntity {

  /**
   * 发货单编码
   */
  @ApiModelProperty("发货单编码")
  @TableField(value = "delivery_code")
  @Column(name = "delivery_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '发货单编码'")
  private String deliveryCode;

  /**
   * 文件类型
   */
  @ApiModelProperty("文件类型")
  @TableField(value = "file_type")
  @Column(name = "file_type", columnDefinition = "VARCHAR(255) COMMENT '文件类型'")
  private String fileType;
}
