package com.biz.crm.dms.business.delivery.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 发货单明细行上该扣项目
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_delivery_detail_deduct")
@Table(name = "dms_delivery_detail_deduct")
@ApiModel(value = "DeliveryDetailDeductEntity", description = "发货单明细行上该扣项目")
@org.hibernate.annotations.Table(appliesTo = "dms_delivery_detail_deduct", comment = "发货单明细行上该扣项目")
public class DeliveryDetailDeductEntity extends TenantEntity {

  /**
   * 发货单明细编码
   */
  @ApiModelProperty("发货单明细编码")
  @TableField(value = "delivery_detail_code")
  @Column(name = "delivery_detail_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '发货单明细编码'")
  private String deliveryDetailCode;

  /**
   * 发货单编码
   */
  @ApiModelProperty("发货单编码")
  @TableField(value = "delivery_code")
  @Column(name = "delivery_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '发货单编码'")
  private String deliveryCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @TableField(value = "order_code")
  @Column(name = "order_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单编码'")
  private String orderCode;

  /**
   * 订单明细编码
   */
  @ApiModelProperty("订单明细编码")
  @TableField(value = "order_detail_code")
  @Column(name = "order_detail_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单明细编码'")
  private String orderDetailCode;

  /**
   * 该扣项目组的key
   */
  @ApiModelProperty("该扣项目组的key")
  @TableField(value = "item_group_key")
  @Column(name = "item_group_key", length = 32, columnDefinition = "VARCHAR(32) COMMENT '该扣项目组的key'")
  private String itemGroupKey;

  /**
   * 该扣项目key
   */
  @ApiModelProperty("该扣项目key")
  @TableField(value = "item_key")
  @Column(name = "item_key", length = 32, columnDefinition = "VARCHAR(32) COMMENT '该扣项目key'")
  private String itemKey;

  /**
   * 该扣项目名称
   */
  @ApiModelProperty("该扣项目名称")
  @TableField(value = "item_name")
  @Column(name = "item_name", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '该扣项目名称'")
  private String itemName;

  /**
   * 该扣项目金额（分摊）
   */
  @ApiModelProperty("该扣项目金额（分摊）")
  @Column(name = "item_amount", nullable = false, columnDefinition = "decimal(20,4) NOT NULL COMMENT '该扣项目金额（分摊）'")
  private BigDecimal itemAmount;

  /**
   * 该扣项目金额数据的由来
   * 比如：【政策优惠】选择了的促销政策集合
   */
  @ApiModelProperty("该扣项目金额数据的由来")
  @TableField(value = "origin_data")
  @Column(name = "origin_data", nullable = false, columnDefinition = "VARCHAR(255) NOT NULL COMMENT '该扣项目金额数据的由来'")
  private String originData;

  /**
   * 数据的由来【类型】
   * 比如：【政策优惠】的政策是整单的，还是行内商品的。
   */
  @ApiModelProperty("数据的由来【类型】")
  @Column(name = "origin_data_type", length = 32, columnDefinition = "varchar(32) COMMENT '数据的由来【类型】'")
  private String originDataType;

}
