package com.biz.crm.dms.business.delivery.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 发货单明细实体类
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DeliveryDetailEntity", description = "发货单明细实体类")
@Entity
@TableName("dms_delivery_detail")
@Table(name = "dms_delivery_detail",
    indexes = {@Index(columnList = "tenant_code, delivery_code, delivery_detail_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_delivery_detail", comment = "发货单明细实体类")
public class DeliveryDetailEntity extends TenantFlagOpEntity {

  /**
   * 发货单编码
   */
  @ApiModelProperty("发货单编码")
  @TableField(value = "delivery_code")
  @Column(name = "delivery_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '发货单编码'")
  private String deliveryCode;

  /**
   * 发货单明细编码
   */
  @ApiModelProperty("发货单明细编码")
  @TableField(value = "delivery_detail_code")
  @Column(name = "delivery_detail_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '发货单明细编码'")
  private String deliveryDetailCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  @TableField(value = "order_type")
  @Column(name = "order_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '订单类型'")
  private String orderType;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @TableField(value = "order_code")
  @Column(name = "order_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单编码'")
  private String orderCode;

  /**
   * 订单明细编码
   */
  @ApiModelProperty("订单明细编码")
  @TableField(value = "order_detail_code")
  @Column(name = "order_detail_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单明细编码'")
  private String orderDetailCode;

  /**
   * 出库单编码
   */
  @ApiModelProperty("出库单编码")
  @TableField(value = "outbound_code")
  @Column(name = "outbound_code", columnDefinition = "VARCHAR(64) COMMENT '出库单编码'")
  private String outboundCode;

  /**
   * 出库状态
   */
  @ApiModelProperty("出库状态")
  @TableField(value = "outbound_status")
  @Column(name = "outbound_status", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '出库状态'")
  private String outboundStatus;

  /**
   * 出库数量
   */
  @ApiModelProperty("出库数量")
  @TableField(value = "outbound_quantity")
  @Column(name = "outbound_quantity", length = 11, columnDefinition = "DECIMAL(20,4) COMMENT '出库数量'")
  private BigDecimal outboundQuantity;

  /**
   * 开票状态
   */
  @ApiModelProperty("开票状态")
  @TableField(value = "invoice_status")
  @Column(name = "invoice_status", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '开票状态'")
  private String invoiceStatus;

  /**
   * 发货数量
   */
  @ApiModelProperty("发货数量")
  @TableField(value = "delivery_quantity")
  @Column(name = "delivery_quantity", length = 11, nullable = false, columnDefinition = "DECIMAL(20,4) NOT NULL COMMENT '发货数量'")
  private BigDecimal deliveryQuantity;

  /**
   * 收货数量
   */
  @ApiModelProperty("收货数量")
  @TableField(value = "receiving_quantity")
  @Column(name = "receiving_quantity", length = 11, columnDefinition = "DECIMAL(20,4) COMMENT '收货数量'")
  private BigDecimal receivingQuantity;

  /**
   * 发货金额
   */
  @ApiModelProperty("发货金额")
  @TableField(value = "deliver_amount")
  @Column(name = "deliver_amount", length = 64, nullable = false, columnDefinition = "DECIMAL(20,4) NOT NULL COMMENT '发货金额'")
  private BigDecimal deliverAmount;

  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  @TableField(value = "goods_code")
  @Column(name = "goods_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '商品/物料编码'")
  private String goodsCode;

  /**
   * 商品/物料名称
   */
  @ApiModelProperty("商品/物料名称")
  @TableField(value = "goods_name")
  @Column(name = "goods_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品/物料名称'")
  private String goodsName;

  /**
   * 历史仓库编码
   */
  @ApiModelProperty("历史仓库编码")
  @TableField(value = "history_warehouse_code")
  @Column(name = "history_warehouse_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '历史仓库编码'")
  private String historyWarehouseCode;

  /**
   * 历史仓库名称
   */
  @ApiModelProperty("历史仓库名称")
  @TableField(value = "history_warehouse_name")
  @Column(name = "history_warehouse_name", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '历史仓库名称'")
  private String historyWarehouseName;

  /**
   * 当前仓库编码
   */
  @ApiModelProperty("当前仓库编码")
  @TableField(value = "current_warehouse_code")
  @Column(name = "current_warehouse_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '当前仓库编码'")
  private String currentWarehouseCode;

  /**
   * 当前仓库名称
   */
  @ApiModelProperty("当前仓库名称")
  @TableField(value = "current_warehouse_name")
  @Column(name = "current_warehouse_name", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '当前仓库名称'")
  private String currentWarehouseName;

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '关联编码 【客户编码】'")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  @TableField(value = "relate_name")
  @Column(name = "relate_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '关联名称 【客户名称】'")
  private String relateName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织编码'")
  private String orgCode;

  /**
   * 组织
   */
  @ApiModelProperty("组织名称")
  @TableField(value = "org_name")
  @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
  private String orgName;
}
