package com.biz.crm.dms.business.delivery.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 发货单实体类
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DeliveryEntity", description = "发货单实体类")
@Entity
@TableName("dms_delivery")
@Table(name = "dms_delivery",
    indexes = {@Index(columnList = "tenant_code ,delivery_code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_delivery", comment = "发货单实体类")
public class DeliveryEntity extends TenantFlagOpEntity {

  /**
   * 发货单编码
   */
  @ApiModelProperty("发货单编码")
  @TableField(value = "delivery_code")
  @Column(name = "delivery_code", nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '发货单编码'")
  private String deliveryCode;

  /**
   * 订单类别（销售订单、促销物料订单）
   */
  @ApiModelProperty("订单类别（销售订单、促销物料订单）")
  @TableField(value = "order_category")
  @Column(name = "order_category", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '订单类别（销售订单、促销物料订单）'")
  private String orderCategory;

  /**
   * 收货状态（1未收货;9完成）
   */
  @ApiModelProperty("收货状态（1未收货;9完成）")
  @TableField(value = "receipt_status")
  @Column(name = "receipt_status", length = 64, nullable = false, columnDefinition = "varchar(64) NOT NULL COMMENT '收货状态（1未收货;9完成）'")
  private String receiptStatus;

  /**
   * 总发货数量
   */
  @ApiModelProperty("总发货数量")
  @TableField(value = "total_delivery_quantity")
  @Column(name = "total_delivery_quantity", length = 11, nullable = false, columnDefinition = "INT(11) NOT NULL COMMENT '总发货数量'")
  private Integer totalDeliveryQuantity;

  /**
   * 总发货金额
   */
  @ApiModelProperty("总发货金额")
  @TableField(value = "total_deliver_amount")
  @Column(name = "total_deliver_amount", length = 64, nullable = false, columnDefinition = "DECIMAL(20,4) NOT NULL COMMENT '总发货金额'")
  private BigDecimal totalDeliverAmount;

}
