package com.biz.crm.dms.business.delivery.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryEntity;
import com.biz.crm.dms.business.delivery.local.mapper.DeliveryMapper;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryDto;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * 发货单表的数据库访问类 {@link DeliveryEntity}
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Component
public class DeliveryVoRepository extends ServiceImpl<DeliveryMapper, DeliveryEntity> {

  /**
   * 分页
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<DeliveryVo> findByConditions(Pageable pageable, DeliveryDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    Page<DeliveryDto> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto = Optional.ofNullable(dto).orElse(new DeliveryDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return baseMapper.findByConditions(page, dto);
  }

}
