package com.biz.crm.dms.business.delivery.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryDetailEntity;
import com.biz.crm.dms.business.delivery.local.repository.DeliveryDetailRepository;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryUnshippedVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryUnshippedVo;
import com.biz.crm.dms.business.order.common.sdk.enums.MaterielOrderTypeEnum;
import com.biz.crm.dms.business.order.sdk.dto.OrderUnshippedPageDto;
import com.biz.crm.dms.business.order.sdk.service.OrderUnshippedVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderUnshippedVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 查询没有发货完毕的订单信息
 * @author pengxi
 */
@Slf4j
@Service
public class DeliveryUnshippedVoServiceImpl implements DeliveryUnshippedVoService {

  @Autowired(required = false)
  private OrderUnshippedVoService orderUnshippedVoService;

  @Autowired(required = false)
  private DeliveryDetailRepository deliveryDetailRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<DeliveryUnshippedVo> findByOrderUnshippedPageDto(Pageable pageable, DeliveryUnshippedPageDto deliveryUnshippedPageDto) {
    if (Objects.isNull(deliveryUnshippedPageDto)) {
      deliveryUnshippedPageDto = new DeliveryUnshippedPageDto();
    }
    OrderUnshippedPageDto order = new OrderUnshippedPageDto();
    order.setOrderCategory(deliveryUnshippedPageDto.getOrderCategory());
    order.setOrderCode(deliveryUnshippedPageDto.getOrderCode());
    order.setOrderCodes(deliveryUnshippedPageDto.getOrderCodes());
    order.setRelateCode(deliveryUnshippedPageDto.getRelateCode());
    order.setRelateName(deliveryUnshippedPageDto.getRelateName());
    order.setOrderStatus(deliveryUnshippedPageDto.getOrderStatus());
    order.setOrderType(deliveryUnshippedPageDto.getOrderType());
    Page<OrderUnshippedVo> orderPage = this.orderUnshippedVoService.findByOrderUnshippedPageDto(pageable, order);
    if (orderPage==null || CollectionUtils.isEmpty(orderPage.getRecords())) {
      return new Page<>();
    }
    List<OrderUnshippedVo> records = orderPage.getRecords();
    List<DeliveryUnshippedVo> deliveryUnshippedVos = (List<DeliveryUnshippedVo>) this.nebulaToolkitService.copyCollectionByBlankList(records, OrderUnshippedVo.class, DeliveryUnshippedVo.class, HashSet.class, LinkedList.class);
    Set<String> orderCodes = deliveryUnshippedVos.stream().map(DeliveryUnshippedVo::getOrderCode).collect(Collectors.toSet());
    List<DeliveryDetailEntity> recordDetails = this.deliveryDetailRepository.findByOrderCodes(TenantUtils.getTenantCode(), orderCodes);

    Map<String, List<DeliveryDetailEntity>> recordDetailMap = recordDetails.stream().collect(Collectors.groupingBy(DeliveryDetailEntity::getOrderCode));
    deliveryUnshippedVos.forEach(o->{
      // 促销物料订单&订单类型为组织类型时
      if (MaterielOrderTypeEnum.ORGANIZATION.getDictCode().equals(o.getOrderType())) {
        if (StringUtils.isNotBlank(o.getRelateCode())) {
          o.setOrgCode(o.getRelateCode());
          o.setRelateCode(null);
        }
        if (StringUtils.isNotBlank(o.getRelateName())) {
          o.setOrgName(o.getRelateName());
          o.setRelateName(null);
        }
      }
      // 发货数量为空时默认为0显示
      o.setDeliveryQuantity(o.getDeliveryQuantity()!=null?o.getDeliveryQuantity():BigDecimal.ZERO);
      if (o.getQuantityOfCommodity()==null) {
        log.error("订单号{}对应的商品数量字段[quantityOfCommodity]为空，属于异常情况，请订单模块检查代码逻辑！！！", o.getOrderCode());
        return;
      }
      List<DeliveryDetailEntity> detailEntities = recordDetailMap.get(o.getOrderCode());
      if (CollectionUtils.isEmpty(detailEntities)) {
        // 此情况为：当前订单号不存在对应发货单记录，所以剩余可发货数量直接等于订单数量
        o.setResidualDeliveryQuantity(o.getQuantityOfCommodity());
      } else {
        // 此情况为：当前订单号已存在对应发货单记录，剩余可发货数量等于商品数量减去发货单累计已发货数量
        BigDecimal totalDeliveryQuantity = Optional.ofNullable(detailEntities).orElse(Lists.newArrayList()).stream().map(DeliveryDetailEntity::getDeliveryQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        o.setResidualDeliveryQuantity(o.getQuantityOfCommodity().subtract(totalDeliveryQuantity));
      }
    });
    Page<DeliveryUnshippedVo> deliveryUnshippedVoPage = new Page<>(orderPage.getCurrent(), orderPage.getSize(), orderPage.getTotal());
    deliveryUnshippedVoPage.setRecords(deliveryUnshippedVos);
    return deliveryUnshippedVoPage;
  }

}
