package com.biz.crm.dms.business.delivery.local.service.notifier;

import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperationType;
import com.biz.crm.dms.business.psi.product.sdk.event.ProductDeliveryListener;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * 出库事件订阅实现
 *
 * @author pengxi
 */
@Slf4j
@Component
public class ProductDeliveryListenerImpl implements ProductDeliveryListener {

  private final DeliveryDetailVoService deliveryDetailVoService;

  public ProductDeliveryListenerImpl(DeliveryDetailVoService deliveryDetailVoService) {
    this.deliveryDetailVoService = deliveryDetailVoService;
  }

  @Override
  public void onCreate(ProductDeliveryBillVo billVo) {
    if (billVo == null || CollectionUtils.isEmpty(billVo.getDetailVos())) {
      return;
    }
    if (ProductStockOperationType.SALE_DELIVER.name().equals(billVo.getProductStockOperationType())
        || ProductStockOperationType.MATERIAL_ORDER_DELIVER.name().equals(billVo.getProductStockOperationType())) {
      // 销售出库和物料订单出库需要更新发货单的出库状态及出库数量
      log.info("销售出库和物料订单出库需要更新发货单的出库状态及出库数量：{}", billVo);
      billVo.getDetailVos().forEach(d-> this.deliveryDetailVoService.updateOutboundStatusByOutboundQuantity(
          billVo.getRelationShipmentOrderCode(), d.getShipmentItemCode(), d.getCurrentQuantity(), true));
    }
  }
}
