/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryDetailVo;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/delivery/deliveryDetail"})
@Api(tags={"\u53d1\u8d27\u5355\u6a21\u5757\uff1aDeliveryDetailVo\uff1a\u83b7\u53d6\u53ef\u9009\u7684\u8ba2\u5355\u53ca\u53d1\u8d27\u5355\u4fe1\u606f"})
public class DeliveryDetailVoController {
    private static final Logger log = LoggerFactory.getLogger(DeliveryDetailVoController.class);
    @Autowired(required=false)
    private DeliveryDetailVoService deliveryDetailVoService;

    @ApiOperation(value="\u83b7\u53d6\u53ef\u9009\u7684\u8ba2\u5355\u53ca\u53d1\u8d27\u5355\u4fe1\u606f")
    @GetMapping(value={"findDeliveryDetails"})
    public Result<Page<DeliveryDetailVo>> findDeliveryDetails(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="deliveryDto", value="\u5206\u9875Dto") DeliveryUnshippedPageDto dto) {
        try {
            LinkedList orderStatusList = Lists.newLinkedList();
            orderStatusList.add(OrderStatusEnum.WAIT_SHIPPED.getDictCode());
            orderStatusList.add(OrderStatusEnum.PART_SHIPPED.getDictCode());
            dto.setOrderStatus((List)orderStatusList);
            Page result = this.deliveryDetailVoService.findOptionalOrderAndDeliveryDetails(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u53d1\u8d27\u5355\u7f16\u7801\u83b7\u53d6\u53d1\u8d27\u5355\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"findDetailByDeliveryCodes"})
    public Result<List<DeliveryDetailVo>> findDetailByDeliveryCodes(@RequestParam(value="deliveryCodes") Set<String> deliveryCodes) {
        try {
            List result = this.deliveryDetailVoService.findDetailByDeliveryCodes(deliveryCodes);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

