/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryUnshippedVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryUnshippedVo;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/delivery/deliveryUnshippedVo"})
@Api(tags={"\u53d1\u8d27\u5355\u6a21\u5757\uff1aDeliveryUnshippedVo\uff1a\u672a\u53d1\u8d27\uff08\u5305\u542b\u90e8\u5206\u5f85\u53d1\u8d27\uff09\u8ba2\u5355\u4fe1\u606f"})
public class DeliveryUnshippedVoController {
    private static final Logger log = LoggerFactory.getLogger(DeliveryUnshippedVoController.class);
    @Autowired(required=false)
    private DeliveryUnshippedVoService deliveryUnshippedVoService;

    @ApiOperation(value="\u672a\u53d1\u8d27\uff08\u5305\u542b\u90e8\u5206\u5f85\u53d1\u8d27\uff09\u8ba2\u5355\u4fe1\u606f\u5206\u9875\u63a5\u53e3")
    @GetMapping(value={"findByOrderUnshippedPageDto"})
    public Result<Page<DeliveryUnshippedVo>> findByOrderUnshippedPageDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="order", value="\u672a\u53d1\u8d27\uff08\u5305\u542b\u90e8\u5206\u5f85\u53d1\u8d27\uff09\u8ba2\u5355\u4fe1\u606f\u5206\u9875\u63a5\u53e3") DeliveryUnshippedPageDto dto) {
        try {
            LinkedList orderStatusList = Lists.newLinkedList();
            orderStatusList.add(OrderStatusEnum.WAIT_SHIPPED.getDictCode());
            orderStatusList.add(OrderStatusEnum.PART_SHIPPED.getDictCode());
            dto.setOrderStatus((List)orderStatusList);
            Page result = this.deliveryUnshippedVoService.findByOrderUnshippedPageDto(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5206\u9875\u63a5\u53e3")
    @GetMapping(value={"findByOrderStatusPageDto"})
    public Result<Page<DeliveryUnshippedVo>> findByOrderStatusPageDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="order", value="\u6839\u636e\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5206\u9875\u63a5\u53e3") DeliveryUnshippedPageDto dto) {
        try {
            Validate.notEmpty((Collection)dto.getOrderStatus(), (String)"\u8ba2\u5355\u72b6\u6001\u6761\u4ef6\u5fc5\u4f20\uff01", (Object[])new Object[0]);
            Page result = this.deliveryUnshippedVoService.findByOrderUnshippedPageDto(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

