/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/delivery/delivery"})
@Api(tags={"\u53d1\u8d27\u5355: DeliveryVo: \u53d1\u8d27\u5355"})
public class DeliveryVoController {
    private static final Logger log = LoggerFactory.getLogger(DeliveryVoController.class);
    @Autowired(required=false)
    private DeliveryVoService deliveryVoService;

    @ApiOperation(value="\u83b7\u53d6\u53d1\u8d27\u5355\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<DeliveryVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="deliveryDto", value="\u5206\u9875Dto") DeliveryDto dto) {
        try {
            return Result.ok((Object)this.deliveryVoService.findByConditions(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u53d1\u8d27\u5355")
    @GetMapping(value={"/findById"})
    public Result<DeliveryVo> findById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            return Result.ok((Object)this.deliveryVoService.findById(id));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u8ba2\u5355\u53f7\u83b7\u53d6\u53d1\u8d27\u5355")
    @GetMapping(value={"/findByOrderCode"})
    public Result<List<DeliveryVo>> findByOrderCode(@RequestParam(value="orderCode") @ApiParam(name="orderCode", value="\u8ba2\u5355\u53f7", required=true) String orderCode) {
        try {
            return Result.ok((Object)this.deliveryVoService.findByOrderCode(orderCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result create(@RequestBody DeliveryDto deliveryDto) {
        try {
            this.deliveryVoService.create(deliveryDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u786e\u8ba4\u53d1\u8d27\u5e76\u521b\u5efa\u51fa\u5e93\u5355")
    @PostMapping(value={"createDeliveryAndOutbound"})
    public Result createDeliveryAndOutbound(@RequestBody DeliveryDto deliveryDto) {
        try {
            this.deliveryVoService.createDeliveryAndOutbound(deliveryDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.deliveryVoService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @Deprecated
    @ApiOperation(value="\u542f\u7528\uff08\u539f\u578b\u8bbe\u8ba1\u53ca\u9700\u6c42\u6587\u6863\u6ca1\u6709\u8be5\u529f\u80fd\uff09")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestParam(value="ids") List<String> ids) {
        try {
            this.deliveryVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528\uff08\u4f5c\u5e9f\uff09")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestParam(value="ids") List<String> ids) {
        try {
            this.deliveryVoService.disableBatch(ids);
            return Result.ok((String)"\u4f5c\u5e9f\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6536\u8d27")
    @PatchMapping(value={"/handleReceiving"})
    public Result handleReceiving(@RequestParam(value="ids") List<String> ids) {
        try {
            this.deliveryVoService.receivingByIds(ids);
            return Result.ok((String)"\u6536\u8d27\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6536\u8d27")
    @PostMapping(value={"/handleReceivingTurnPatch"})
    public Result handleReceivingTurnPatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.deliveryVoService.receivingByIds(ids);
            return Result.ok((String)"\u6536\u8d27\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

