/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.notifier;

import com.biz.crm.dms.business.delivery.local.entity.DeliveryDetailDeductEntity;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryDetailEntity;
import com.biz.crm.dms.business.delivery.local.repository.DeliveryDetailDeductRepository;
import com.biz.crm.dms.business.delivery.local.repository.DeliveryDetailRepository;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.order.common.sdk.model.TallyItemRegisterModel;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.sdk.event.OrderCloseListener;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPayVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderPayVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrderCloseListenerImpl
implements OrderCloseListener {
    @Autowired(required=false)
    private DeliveryDetailVoService deliveryDetailVoService;
    @Autowired(required=false)
    private DeliveryDetailRepository deliveryDetailRepository;
    @Autowired(required=false)
    private DeliveryDetailDeductRepository deliveryDetailDeductRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Qualifier(value="CapitalTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister capitalTallyItemRegister;
    @Qualifier(value="CreditTallyItemRegister")
    @Autowired(required=false)
    private TallyItemRegister creditTallyItemRegister;

    public OrderVo onReturn(OrderVo orderVo) {
        OrderVo returnOrder = (OrderVo)this.nebulaToolkitService.copyObjectByBlankList((Object)orderVo, OrderVo.class, HashSet.class, LinkedList.class, new String[0]);
        List<DeliveryDetailEntity> detailEntities = this.deliveryDetailRepository.findByOrderCodes(TenantUtils.getTenantCode(), Sets.newHashSet((Object[])new String[]{orderVo.getOrderCode()}));
        Map<String, List<DeliveryDetailEntity>> odcToDeliveryDetailMap = detailEntities.stream().collect(Collectors.groupingBy(DeliveryDetailEntity::getOrderDetailCode));
        List<DeliveryDetailDeductEntity> recordDeductEntities = this.deliveryDetailDeductRepository.findByOrderCodes(Sets.newHashSet((Object[])new String[]{orderVo.getOrderCode()}));
        Map<String, List<DeliveryDetailDeductEntity>> recordDeductMap = recordDeductEntities.stream().collect(Collectors.groupingBy(DeliveryDetailDeductEntity::getOrderDetailCode));
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        List orderDetails = orderVo.getOrderDetails();
        ArrayList<OrderDetailVo> returnOrderDetails = new ArrayList<OrderDetailVo>(orderDetails.size());
        BigDecimal orderTotalDeliverAmount = BigDecimal.ZERO;
        for (OrderDetailVo orderDetail : orderDetails) {
            String orderDetailCode = orderDetail.getOrderDetailCode();
            OrderDetailVo returnOrderDetail = (OrderDetailVo)this.nebulaToolkitService.copyObjectByBlankList((Object)orderDetail, OrderDetailVo.class, HashSet.class, LinkedList.class, new String[0]);
            List<DeliveryDetailEntity> deliveryDetailEntities = odcToDeliveryDetailMap.get(orderDetailCode);
            BigDecimal totalDeliveryQuantity = BigDecimal.ZERO;
            BigDecimal totalDeliverAmount = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(deliveryDetailEntities)) {
                for (DeliveryDetailEntity deliveryDetail : deliveryDetailEntities) {
                    BigDecimal deliveryQuantity = deliveryDetail.getDeliveryQuantity();
                    totalDeliveryQuantity = totalDeliveryQuantity.add(deliveryQuantity);
                    BigDecimal deliverAmount = deliveryDetail.getDeliverAmount();
                    totalDeliverAmount = totalDeliverAmount.add(deliverAmount);
                    orderTotalDeliverAmount = orderTotalDeliverAmount.add(deliverAmount);
                }
            }
            returnOrderDetail.setQuantity(orderDetail.getQuantity().subtract(totalDeliveryQuantity));
            returnOrderDetail.setShouldPaymentAmount(orderDetail.getShouldPaymentAmount().subtract(totalDeliverAmount));
            List orderDetailPays = orderDetail.getOrderDetailPays();
            ArrayList<OrderDetailPayVo> returnOrderDetailPays = new ArrayList<OrderDetailPayVo>(orderDetailPays.size());
            for (OrderDetailPayVo orderDetailPay : orderDetailPays) {
                OrderDetailPayVo returnOrderDetailPayVo = (OrderDetailPayVo)this.nebulaToolkitService.copyObjectByBlankList((Object)orderDetailPay, OrderDetailPayVo.class, HashSet.class, LinkedList.class, new String[0]);
                List<DeliveryDetailDeductEntity> recordDeductList = recordDeductMap.get(orderDetailCode);
                BigDecimal totalAmount = Optional.ofNullable(recordDeductList).orElse(Lists.newArrayList()).stream().filter(d -> d.getItemKey().equals(orderDetailPay.getItemKey())).map(DeliveryDetailDeductEntity::getItemAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal temp = (BigDecimal)map.get(orderDetailPay.getItemKey());
                temp = temp != null ? temp.add(totalAmount) : totalAmount;
                map.put(orderDetailPay.getItemKey(), temp);
                returnOrderDetailPayVo.setItemAmount(orderDetailPay.getItemAmount().subtract(totalAmount));
                returnOrderDetailPays.add(returnOrderDetailPayVo);
            }
            returnOrderDetail.setOrderDetailPays(returnOrderDetailPays);
            returnOrderDetails.add(returnOrderDetail);
        }
        returnOrder.setOrderDetails(returnOrderDetails);
        List orderPays = orderVo.getOrderPays();
        BigDecimal itemAmount = this.getCreditPayAmount(orderPays);
        BigDecimal actualAmountPaid = returnOrder.getActualAmountPaid();
        BigDecimal creditRate = itemAmount.divide(actualAmountPaid, 4, RoundingMode.HALF_UP);
        BigDecimal creditDeliverAmount = orderTotalDeliverAmount.multiply(creditRate);
        BigDecimal capitalDeliverAmount = orderTotalDeliverAmount.subtract(creditDeliverAmount);
        map.put(this.creditTallyItemRegister.findTallyItemRegisterModel().getItemKey(), creditDeliverAmount);
        map.put(this.capitalTallyItemRegister.findTallyItemRegisterModel().getItemKey(), capitalDeliverAmount);
        returnOrder.setActualAmountPaid(actualAmountPaid.subtract(orderTotalDeliverAmount));
        ArrayList<OrderPayVo> returnOrderPays = new ArrayList<OrderPayVo>(orderPays.size());
        for (OrderPayVo orderPay : orderPays) {
            OrderPayVo returnOrderPayVo = (OrderPayVo)this.nebulaToolkitService.copyObjectByBlankList((Object)orderPay, OrderPayVo.class, HashSet.class, LinkedList.class, new String[0]);
            String itemKey = orderPay.getItemKey();
            BigDecimal temp = (BigDecimal)map.get(itemKey);
            if (temp != null) {
                BigDecimal subtract = orderPay.getItemAmount().subtract(temp);
                returnOrderPayVo.setItemAmount(subtract);
            }
            returnOrderPays.add(returnOrderPayVo);
        }
        returnOrder.setOrderPays(returnOrderPays);
        return returnOrder;
    }

    private BigDecimal getCreditPayAmount(List<OrderPayVo> orderPays) {
        BigDecimal itemAmount = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(orderPays)) {
            return itemAmount;
        }
        for (OrderPayVo orderPay : orderPays) {
            TallyItemRegisterModel tallyItemRegisterModel;
            String itemKey1;
            String itemKey = orderPay.getItemKey();
            if (StringUtils.isBlank((CharSequence)itemKey) || !itemKey.equals(itemKey1 = (tallyItemRegisterModel = this.creditTallyItemRegister.findTallyItemRegisterModel()).getItemKey())) continue;
            itemAmount = orderPay.getItemAmount();
            break;
        }
        return itemAmount;
    }
}

