/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryDetailEntity;
import com.biz.crm.dms.business.delivery.local.mapper.DeliveryDetailMapper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class DeliveryDetailRepository
extends ServiceImpl<DeliveryDetailMapper, DeliveryDetailEntity> {
    public List<DeliveryDetailEntity> findByOrderCodes(String tenantCode, Set<String> orderCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(DeliveryDetailEntity::getOrderCode, orderCodes)).list();
    }

    public List<DeliveryDetailEntity> findByDeliveryCodes(String tenantCode, Set<String> deliveryCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(DeliveryDetailEntity::getDeliveryCode, deliveryCodes)).list();
    }

    public List<DeliveryDetailEntity> findByRelateCodesInAndGoodsCodesInAndBetweenStartTimeAndEndTime(String tenantCode, Set<String> relateCodes, Set<String> goodsCodes, Date startTime, Date endTime) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(CollectionUtils.isNotEmpty(relateCodes), DeliveryDetailEntity::getRelateCode, relateCodes)).in(CollectionUtils.isNotEmpty(goodsCodes), DeliveryDetailEntity::getGoodsCode, goodsCodes)).gt(Objects.nonNull(startTime), UuidOpEntity::getCreateTime, (Object)startTime)).lt(Objects.nonNull(endTime), UuidOpEntity::getCreateTime, (Object)endTime)).list();
    }

    public DeliveryDetailEntity findByDeliveryCodeAndDeliveryDetailCode(String tenantCode, String deliveryCode, String deliveryDetailCode) {
        return (DeliveryDetailEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(DeliveryDetailEntity::getDeliveryCode, (Object)deliveryCode)).eq(DeliveryDetailEntity::getDeliveryDetailCode, (Object)deliveryDetailCode)).one());
    }

    public void updateOutboundStatusAndOutboundQuantityById(String outboundStatus, BigDecimal outboundQuantity, String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(DeliveryDetailEntity::getOutboundStatus, (Object)outboundStatus)).set(DeliveryDetailEntity::getOutboundQuantity, (Object)outboundQuantity)).eq(UuidEntity::getId, (Object)id)).update();
    }

    public void deleteByDeliveryCodes(String tenantCode, Set<String> deliveryCodes) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(DeliveryDetailEntity::getDeliveryCode, deliveryCodes)).remove();
    }

    public void receivingByDeliveryCode(String deliveryCode, BigDecimal receivingQuantity) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(DeliveryDetailEntity::getDeliveryCode, (Object)deliveryCode)).set(DeliveryDetailEntity::getReceivingQuantity, (Object)receivingQuantity)).update();
    }

    public void updateEnableStatusByDeliveryCodes(String tenantCode, Set<String> deliveryCodes, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(DeliveryDetailEntity::getDeliveryCode, deliveryCodes)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }
}

