/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryEntity;
import com.biz.crm.dms.business.delivery.local.mapper.DeliveryMapper;
import com.biz.crm.dms.business.delivery.sdk.enums.ReceiptStatusEnum;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class DeliveryRepository
extends ServiceImpl<DeliveryMapper, DeliveryEntity> {
    public DeliveryEntity findByDeliveryCode(String tenantCode, String deliveryCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(DeliveryEntity::getDeliveryCode, (Object)deliveryCode);
        wrapper.last("limit 1");
        return (DeliveryEntity)((Object)((DeliveryMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    public List<DeliveryEntity> findByDeliveryCodes(Set<String> deliveryCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(DeliveryEntity::getDeliveryCode, deliveryCodes)).list();
    }

    public List<DeliveryEntity> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void receivingByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(DeliveryEntity::getReceiptStatus, (Object)ReceiptStatusEnum.COMPLETE.getDictCode())).update();
    }
}

