/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryDetailDeductEntity;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryDetailEntity;
import com.biz.crm.dms.business.delivery.local.repository.DeliveryDetailDeductRepository;
import com.biz.crm.dms.business.delivery.local.repository.DeliveryDetailRepository;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryDetailDto;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliverySalesTargetDto;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.enums.OutboundStatusEnum;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryUnshippedVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryDetailDeductVo;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryDetailVo;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryUnshippedVo;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPayVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.DeliveryStockDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperationType;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.StockType;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.DeliveryStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.DeliveryStockVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeliveryDetailVoServiceImpl
implements DeliveryDetailVoService {
    private static final Logger log = LoggerFactory.getLogger(DeliveryDetailVoServiceImpl.class);
    @Autowired(required=false)
    private DeliveryDetailRepository deliveryDetailRepository;
    @Autowired(required=false)
    private DeliveryDetailDeductRepository deliveryDetailDeductRepository;
    @Autowired(required=false)
    private DeliveryStockVoService deliveryStockVoService;
    @Autowired(required=false)
    private ProductStockVoService productStockVoService;
    @Autowired(required=false)
    private DeliveryUnshippedVoService deliveryUnshippedVoService;
    @Autowired(required=false)
    private OrderVoService orderVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<DeliveryDetailVo> findByOrderCodes(Set<String> orderCodes) {
        if (CollectionUtils.isEmpty(orderCodes)) {
            return Lists.newArrayList();
        }
        List<DeliveryDetailEntity> detailEntities = this.deliveryDetailRepository.findByOrderCodes(TenantUtils.getTenantCode(), orderCodes);
        if (CollectionUtils.isEmpty(detailEntities)) {
            return Lists.newArrayList();
        }
        List deliveryDetailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailEntities, DeliveryDetailEntity.class, DeliveryDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.findDeductByDeliveryDetailVos(deliveryDetailVos);
        return deliveryDetailVos;
    }

    public List<DeliveryDetailVo> findByDeliveryCodes(Set<String> deliveryCodes) {
        if (CollectionUtils.isEmpty(deliveryCodes)) {
            return Lists.newArrayList();
        }
        List<DeliveryDetailEntity> detailEntities = this.deliveryDetailRepository.findByDeliveryCodes(TenantUtils.getTenantCode(), deliveryCodes);
        if (CollectionUtils.isEmpty(detailEntities)) {
            return Lists.newArrayList();
        }
        List deliveryDetailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailEntities, DeliveryDetailEntity.class, DeliveryDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.findDeductByDeliveryDetailVos(deliveryDetailVos);
        return deliveryDetailVos;
    }

    public Page<DeliveryDetailVo> findOrderAndStockDeliveryDetails(Pageable pageable, DeliveryUnshippedPageDto dto) {
        Page deliveryUnshippedVoPage = this.deliveryUnshippedVoService.findByOrderUnshippedPageDto(pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)3000)), dto);
        List orderVoList = deliveryUnshippedVoPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)orderVoList)) {
            return new Page();
        }
        List orderCodes = orderVoList.stream().map(DeliveryUnshippedVo::getOrderCode).distinct().collect(Collectors.toList());
        List orderVos = this.orderVoService.findByOrderCodes(orderCodes);
        if (CollectionUtils.isEmpty((Collection)orderVos)) {
            return new Page();
        }
        Map orderMap = orderVos.stream().collect(Collectors.toMap(OrderVo::getOrderCode, Function.identity()));
        Map<String, List<DeliveryStockVo>> deliveryStockVoMap = this.findDeliveryStockByOrderVos(orderVos);
        List<DeliveryDetailVo> recordDetailVos = this.findByOrderCodes(new HashSet<String>(orderCodes));
        Map<String, List<DeliveryDetailVo>> recordDetailMap = recordDetailVos.stream().collect(Collectors.groupingBy(x -> StringUtils.join((Object[])new String[]{x.getOrderCode(), "_", x.getOrderDetailCode()})));
        ArrayList optionalDetails = Lists.newArrayList();
        orderVoList.forEach(o -> {
            OrderVo orderVo = (OrderVo)orderMap.get(o.getOrderCode());
            if (orderVo == null) {
                return;
            }
            List orderDetailVos = orderVo.getOrderDetails();
            if (CollectionUtils.isEmpty((Collection)orderDetailVos)) {
                return;
            }
            orderDetailVos.forEach(od -> {
                String orderLineKey = StringUtils.join((Object[])new String[]{od.getOrderCode(), "_", od.getOrderDetailCode()});
                List deliveryStockVoList = (List)deliveryStockVoMap.get(orderLineKey);
                Validate.notEmpty((Collection)deliveryStockVoList, (String)String.format("\u5f02\u5e38\u6570\u636e\uff1a\u8ba2\u5355[%s]\u6ca1\u6709\u5e93\u5b58\u4fe1\u606f\uff01", orderLineKey), (Object[])new Object[0]);
                deliveryStockVoList.forEach(stockVo -> {
                    DeliveryDetailVo deliveryDetailVo = (DeliveryDetailVo)this.nebulaToolkitService.copyObjectByWhiteList(od, DeliveryDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
                    deliveryDetailVo.setOriginalOrderCode(o.getOriginalOrderCode());
                    deliveryDetailVo.setOrderType(o.getOrderType());
                    deliveryDetailVo.setRelateCode(o.getRelateCode());
                    deliveryDetailVo.setRelateName(o.getRelateName());
                    deliveryDetailVo.setOrgCode(o.getOrgCode());
                    deliveryDetailVo.setOrgName(o.getOrgName());
                    deliveryDetailVo.setDetailedAddress(o.getDetailedAddress());
                    deliveryDetailVo.setCityCode(o.getCityCode());
                    deliveryDetailVo.setContactName(o.getContactName());
                    deliveryDetailVo.setContactPhone(o.getContactPhone());
                    deliveryDetailVo.setPickUpWay(orderVo.getPickUpWay());
                    deliveryDetailVo.setHistoryWarehouseCode(stockVo.getWarehouseCode());
                    deliveryDetailVo.setHistoryWarehouseName(stockVo.getWarehouseName());
                    deliveryDetailVo.setAvailableStock(stockVo.getAvailableStock());
                    deliveryDetailVo.setTotalStock(stockVo.getTotalStock());
                    deliveryDetailVo.setFrozenQuantity(stockVo.getFrozenQuantity());
                    List deliveryDetailRecords = (List)recordDetailMap.get(orderLineKey);
                    BigDecimal notOutboundQuantity = Optional.ofNullable(deliveryDetailRecords).orElse(Lists.newArrayList()).stream().filter(dd -> stockVo.getWarehouseCode().equals(dd.getCurrentWarehouseCode())).reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getDeliveryQuantity().subtract(y.getOutboundQuantity() != null ? y.getOutboundQuantity() : BigDecimal.ZERO)), BigDecimal::add);
                    BigDecimal frozenQuantity = stockVo.getFrozenQuantity() != null ? stockVo.getFrozenQuantity() : BigDecimal.ZERO;
                    deliveryDetailVo.setMaxAvailableStock(frozenQuantity.subtract(notOutboundQuantity));
                    if (CollectionUtils.isNotEmpty((Collection)od.getOrderDetailPays())) {
                        List orderDetailDeductVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)od.getOrderDetailPays(), OrderDetailPayVo.class, DeliveryDetailDeductVo.class, HashSet.class, ArrayList.class, new String[0]);
                        deliveryDetailVo.setOrderDetailDeductVos(orderDetailDeductVos);
                    }
                    optionalDetails.add(deliveryDetailVo);
                });
            });
        });
        Page pageResult = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        pageResult.setRecords((List)optionalDetails);
        pageResult.setTotal(deliveryUnshippedVoPage.getTotal());
        return pageResult;
    }

    public Page<DeliveryDetailVo> findOptionalOrderAndDeliveryDetails(Pageable pageable, DeliveryUnshippedPageDto dto) {
        Page<DeliveryDetailVo> deliveryDetailVoPage = this.findOrderAndStockDeliveryDetails(pageable, dto);
        ArrayList optionalDetails = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)deliveryDetailVoPage.getRecords())) {
            deliveryDetailVoPage.getRecords().forEach(dd -> {
                if (BigDecimal.ZERO.compareTo(dd.getMaxAvailableStock()) >= 0) {
                    return;
                }
                optionalDetails.add(dd);
            });
        }
        Page pageResult = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        pageResult.setRecords((List)optionalDetails);
        pageResult.setTotal(deliveryDetailVoPage.getTotal());
        return pageResult;
    }

    public List<DeliveryDetailVo> findDetailByDeliveryCodes(Set<String> deliveryCodes) {
        List<DeliveryDetailVo> detailVos = this.findByDeliveryCodes(deliveryCodes);
        if (CollectionUtils.isEmpty(detailVos)) {
            return Lists.newArrayList();
        }
        List orderCodes = detailVos.stream().map(DeliveryDetailVo::getOrderCode).distinct().collect(Collectors.toList());
        DeliveryUnshippedPageDto optionalOrderDto = new DeliveryUnshippedPageDto();
        optionalOrderDto.setOrderCodes(orderCodes);
        Page<DeliveryDetailVo> optionalDetails = this.findOrderAndStockDeliveryDetails(null, optionalOrderDto);
        Map optionalDetailMap = Optional.ofNullable(optionalDetails.getRecords()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(dd -> StringUtils.join((Object[])new String[]{dd.getOrderCode(), "_", dd.getOrderDetailCode(), "_", dd.getHistoryWarehouseCode()}), Function.identity()));
        detailVos.forEach(dd -> {
            String dimensionKey = StringUtils.join((Object[])new String[]{dd.getOrderCode(), "_", dd.getOrderDetailCode(), "_", dd.getHistoryWarehouseCode()});
            DeliveryDetailVo orderDetailVo = (DeliveryDetailVo)optionalDetailMap.get(dimensionKey);
            if (orderDetailVo != null) {
                dd.setDeliverSalesAmount(dd.getDeliveryQuantity().divide(orderDetailVo.getQuantity(), 4, RoundingMode.HALF_UP).multiply(orderDetailVo.getSalesAmount()));
                dd.setDeliverShouldPaymentAmount(dd.getDeliveryQuantity().divide(orderDetailVo.getQuantity(), 4, RoundingMode.HALF_UP).multiply(orderDetailVo.getShouldPaymentAmount()));
                dd.setOrderCode(orderDetailVo.getOrderCode());
                dd.setOrderDetailCode(orderDetailVo.getOrderDetailCode());
                dd.setOrderType(orderDetailVo.getOrderType());
                dd.setItemType(orderDetailVo.getItemType());
                dd.setGoodsCode(orderDetailVo.getGoodsCode());
                dd.setGoodsName(orderDetailVo.getGoodsName());
                dd.setSpec(orderDetailVo.getSpec());
                dd.setUnite(orderDetailVo.getUnite());
                dd.setQuantity(orderDetailVo.getQuantity());
                dd.setSalesAmount(orderDetailVo.getSalesAmount());
                dd.setShouldPaymentAmount(orderDetailVo.getShouldPaymentAmount());
                dd.setPresetUnitPrice(orderDetailVo.getPresetUnitPrice());
                dd.setRelateCode(orderDetailVo.getRelateCode());
                dd.setRelateName(orderDetailVo.getRelateName());
                dd.setCityCode(orderDetailVo.getCityCode());
                dd.setOrgCode(orderDetailVo.getOrgCode());
                dd.setOrgName(orderDetailVo.getOrgName());
                dd.setHistoryWarehouseCode(orderDetailVo.getHistoryWarehouseCode());
                dd.setHistoryWarehouseName(orderDetailVo.getHistoryWarehouseName());
                dd.setDetailedAddress(orderDetailVo.getDetailedAddress());
                dd.setContactName(orderDetailVo.getContactName());
                dd.setContactPhone(orderDetailVo.getContactPhone());
                dd.setPickUpWay(orderDetailVo.getPickUpWay());
                dd.setTotalStock(orderDetailVo.getTotalStock());
                dd.setAvailableStock(orderDetailVo.getAvailableStock());
                dd.setMaxAvailableStock(orderDetailVo.getMaxAvailableStock());
                dd.setOrderDetailDeductVos(orderDetailVo.getOrderDetailDeductVos());
                dd.setOutboundQuantity(dd.getOutboundQuantity() == null ? BigDecimal.ZERO : dd.getOutboundQuantity());
            }
        });
        return detailVos;
    }

    @Transactional
    public void createBatch(List<DeliveryDetailDto> deliveryDetailDtoList) {
        if (CollectionUtils.isEmpty(deliveryDetailDtoList)) {
            return;
        }
        List<String> orderCodes = deliveryDetailDtoList.stream().map(DeliveryDetailDto::getOrderCode).distinct().collect(Collectors.toList());
        DeliveryUnshippedPageDto optionalOrderDto = new DeliveryUnshippedPageDto();
        optionalOrderDto.setOrderCodes(orderCodes);
        Page<DeliveryDetailVo> optionalDetails = this.findOrderAndStockDeliveryDetails(null, optionalOrderDto);
        Map optionalDetailMap = Optional.ofNullable(optionalDetails.getRecords()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(dd -> StringUtils.join((Object[])new String[]{dd.getOrderCode(), "_", dd.getOrderDetailCode(), "_", dd.getHistoryWarehouseCode()}), Function.identity()));
        Map<String, DeliveryStockVo> deliveryStockVoMap = this.findDeliveryStockInfoMapByDeliveryDetailDtoList(deliveryDetailDtoList);
        List<DeliveryDetailEntity> recordDetailEntities = this.deliveryDetailRepository.findByOrderCodes(TenantUtils.getTenantCode(), new HashSet<String>(orderCodes));
        Map<String, List<DeliveryDetailEntity>> recordDetailMap = recordDetailEntities.stream().collect(Collectors.groupingBy(dd -> StringUtils.join((Object[])new String[]{dd.getOrderCode(), "_" + dd.getOrderDetailCode(), "_", dd.getCurrentWarehouseCode()})));
        List<DeliveryDetailDeductEntity> recordDeductEntities = this.deliveryDetailDeductRepository.findByOrderCodes(orderCodes);
        Map<String, List<DeliveryDetailDeductEntity>> recordDeductMap = recordDeductEntities.stream().collect(Collectors.groupingBy(x -> StringUtils.join((Object[])new String[]{x.getOrderCode(), "_", x.getOrderDetailCode()})));
        ArrayList detailEntities = new ArrayList(deliveryDetailDtoList.size());
        ArrayList detailDeductEntities = new ArrayList();
        deliveryDetailDtoList.forEach(dd -> {
            Validate.notNull((Object)dd.getHistoryWarehouseCode(), (String)"\u5386\u53f2\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dd.getHistoryWarehouseName(), (String)"\u5386\u53f2\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dd.getCurrentWarehouseCode(), (String)"\u5f53\u524d\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dd.getCurrentWarehouseName(), (String)"\u5f53\u524d\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (dd.getDeliveryQuantity() == null || dd.getDeliveryQuantity().compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            String tip = String.format("\u8ba2\u5355\u53f7[%s]%s[%s]%s[%s]", dd.getOrderCode(), dd.getHistoryWarehouseName(), dd.getHistoryWarehouseCode(), dd.getGoodsName(), dd.getGoodsCode());
            Validate.isTrue((dd.getDeliveryQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)String.format("%s\u53d1\u8d27\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01", tip), (Object[])new Object[0]);
            DeliveryDetailVo optionalDetailVo = (DeliveryDetailVo)optionalDetailMap.get(StringUtils.join((Object[])new String[]{dd.getOrderCode(), "_", dd.getOrderDetailCode(), "_", dd.getHistoryWarehouseCode()}));
            Validate.notNull((Object)optionalDetailVo, (String)String.format("%s\u672a\u627e\u5230\u8ba2\u5355\u4fe1\u606f\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
            BigDecimal maxAvailableStock = optionalDetailVo.getMaxAvailableStock();
            Validate.notNull((Object)maxAvailableStock, (String)String.format("%s\u6700\u5927\u53ef\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
            Validate.isTrue((dd.getDeliveryQuantity().compareTo(maxAvailableStock) < 1 ? 1 : 0) != 0, (String)String.format("%s\u8d85\u8fc7\u6700\u5927\u53ef\u53d1\u8d27\u6570\u91cf\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
            DeliveryStockVo deliveryStockVo = (DeliveryStockVo)deliveryStockVoMap.get(StringUtils.join((Object[])new String[]{dd.getOrderCode(), "_", dd.getHistoryWarehouseCode(), "_", dd.getGoodsCode()}));
            Validate.notNull((Object)deliveryStockVo, (String)String.format("%s\u672a\u627e\u5230\u5e93\u5b58\u4fe1\u606f\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
            BigDecimal frozenStock = deliveryStockVo.getFrozenStock();
            Validate.notNull((Object)frozenStock, (String)String.format("%s\u5e93\u5b58\u5360\u7528\u6570\u91cf\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
            List detailEntityList = (List)recordDetailMap.get(StringUtils.join((Object[])new String[]{dd.getOrderCode(), "_", dd.getOrderDetailCode(), "_", dd.getCurrentWarehouseCode()}));
            BigDecimal notDeliveredStock = Optional.ofNullable(detailEntityList).orElse(Lists.newArrayList()).stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getDeliveryQuantity().subtract(y.getOutboundQuantity() != null ? y.getOutboundQuantity() : BigDecimal.ZERO)), BigDecimal::add);
            BigDecimal surplusAvailableStock = frozenStock.subtract(notDeliveredStock);
            log.info(String.format("%s\uff0c\u51bb\u7ed3\u6570\u91cf%s\uff0c\u672a\u51fa\u5e93\u6570\u91cf%s\uff0c\u5269\u4f59\u53ef\u53d1\u8d27\u6570\u91cf%s\uff0c\u53d1\u8d27\u6570\u91cf%s\uff01", tip, frozenStock, notDeliveredStock, surplusAvailableStock, dd.getDeliveryQuantity()));
            Validate.isTrue((dd.getDeliveryQuantity().compareTo(surplusAvailableStock) < 1 ? 1 : 0) != 0, (String)String.format("%s\u8d85\u8fc7\u5269\u4f59\u53ef\u53d1\u8d27\u6570\u91cf%s\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip, surplusAvailableStock), (Object[])new Object[0]);
            DeliveryDetailEntity detailEntity = (DeliveryDetailEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dd, DeliveryDetailEntity.class, HashSet.class, ArrayList.class, new String[0])));
            detailEntity.setDeliverAmount(optionalDetailVo.getPresetUnitPrice().multiply(detailEntity.getDeliveryQuantity()));
            detailEntities.add(detailEntity);
            if (CollectionUtils.isEmpty((Collection)dd.getOrderDetailDeductVos())) {
                return;
            }
            AtomicReference<Boolean> isLastTime = new AtomicReference<Boolean>(Boolean.FALSE);
            if (optionalDetailVo.getMaxAvailableStock().compareTo(dd.getDeliveryQuantity()) == 0) {
                isLastTime.set(Boolean.TRUE);
            }
            Map optionalDeductMap = Optional.ofNullable(optionalDetailVo.getOrderDetailDeductVos()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(o -> StringUtils.join((Object[])new String[]{o.getOrderCode(), "_", o.getOrderDetailCode(), "_", o.getItemKey(), "_", o.getOriginData()}), Function.identity()));
            dd.getOrderDetailDeductVos().forEach(dto -> {
                if (StringUtils.isBlank((CharSequence)dto.getItemKey())) {
                    return;
                }
                String key = StringUtils.join((Object[])new String[]{dto.getOrderCode(), "_", dto.getOrderDetailCode(), "_", dto.getItemKey(), "_", dto.getOriginData()});
                DeliveryDetailDeductVo optionalDeductVo = (DeliveryDetailDeductVo)optionalDeductMap.get(key);
                Validate.notNull((Object)optionalDeductVo, (String)String.format("\u5f53\u524d\u8ba2\u5355[%s]\u884c\u53f7[%s]\u4e0d\u80fd\u7ee7\u7eed\u53d1\u8d27\uff01", dto.getOrderCode(), dto.getOrderDetailCode()), (Object[])new Object[0]);
                Validate.notNull((Object)optionalDeductVo.getItemAmount(), (String)String.format("\u5f53\u524d\u8ba2\u5355[%s]\u884c\u53f7[%s]\u4e0d\u80fd\u7ee7\u7eed\u53d1\u8d27\uff01", dto.getOrderCode(), dto.getOrderDetailCode()), (Object[])new Object[0]);
                DeliveryDetailDeductEntity detailDeductEntity = new DeliveryDetailDeductEntity();
                detailDeductEntity.setTenantCode(dd.getTenantCode());
                detailDeductEntity.setDeliveryCode(dd.getDeliveryCode());
                detailDeductEntity.setDeliveryDetailCode(dd.getDeliveryDetailCode());
                detailDeductEntity.setOrderCode(dd.getOrderCode());
                detailDeductEntity.setOrderDetailCode(dd.getOrderDetailCode());
                detailDeductEntity.setItemGroupKey(dto.getItemGroupKey());
                detailDeductEntity.setItemKey(dto.getItemKey());
                detailDeductEntity.setItemName(dto.getItemName());
                detailDeductEntity.setItemAmount(dto.getItemAmount());
                detailDeductEntity.setOriginData(dto.getOriginData());
                detailDeductEntity.setOriginDataType(dto.getOriginDataType());
                if (((Boolean)isLastTime.get()).booleanValue()) {
                    List recordDeductList = (List)recordDeductMap.get(StringUtils.join((Object[])new String[]{dd.getOrderCode(), "_", dd.getOrderDetailCode()}));
                    String originData = StringUtils.isBlank((CharSequence)dto.getOriginData()) ? "" : dto.getOriginData();
                    BigDecimal totalAmount = Optional.ofNullable(recordDeductList).orElse(Lists.newArrayList()).stream().filter(d -> d.getItemKey().equals(dto.getItemKey()) && (StringUtils.isBlank((CharSequence)d.getOriginData()) ? "" : d.getOriginData()).equals(StringUtils.isBlank((CharSequence)dto.getOriginData()) ? "" : dto.getOriginData())).map(DeliveryDetailDeductEntity::getItemAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    detailDeductEntity.setItemAmount(optionalDeductVo.getItemAmount().subtract(totalAmount));
                } else {
                    detailDeductEntity.setItemAmount(dd.getDeliveryQuantity().divide(optionalDetailVo.getQuantity(), 4, RoundingMode.HALF_UP).multiply(optionalDeductVo.getItemAmount()));
                }
                detailDeductEntities.add(detailDeductEntity);
            });
        });
        Map<String, List<DeliveryDetailDto>> deliveryDetailDtoMap = deliveryDetailDtoList.stream().collect(Collectors.groupingBy(dd -> StringUtils.join((Object[])new String[]{dd.getCurrentWarehouseCode(), "_", dd.getGoodsCode()})));
        deliveryDetailDtoMap.forEach((k, detailDtoList) -> {
            DeliveryDetailDto deliveryDetailDto = (DeliveryDetailDto)detailDtoList.get(0);
            Validate.notNull((Object)deliveryDetailDto.getCurrentWarehouseCode(), (String)"\u5f53\u524d\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)deliveryDetailDto.getCurrentWarehouseCode(), (String)"\u5f53\u524d\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)deliveryDetailDto.getCurrentWarehouseName(), (String)"\u5f53\u524d\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String tip = String.format("%s[%s]%s[%s]", deliveryDetailDto.getCurrentWarehouseName(), deliveryDetailDto.getCurrentWarehouseCode(), deliveryDetailDto.getGoodsName(), deliveryDetailDto.getGoodsCode());
            String dimensionKey = StringUtils.join((Object[])new String[]{deliveryDetailDto.getOrderCode(), "_", deliveryDetailDto.getCurrentWarehouseCode(), "_", deliveryDetailDto.getGoodsCode()});
            DeliveryStockVo deliveryStockVo = (DeliveryStockVo)deliveryStockVoMap.get(dimensionKey);
            Validate.notNull((Object)deliveryStockVo, (String)String.format("%s\u672a\u627e\u5230\u5e93\u5b58\u4fe1\u606f\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
            BigDecimal totalStock = deliveryStockVo.getTotalStock();
            BigDecimal availableStock = deliveryStockVo.getAvailableStock();
            Validate.notNull((Object)totalStock, (String)String.format("%s\u5b9e\u9645\u5e93\u5b58\u91cf\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
            Validate.notNull((Object)availableStock, (String)String.format("%s\u53ef\u7528\u5e93\u5b58\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
            BigDecimal itemDtoTotalQuantity = detailDtoList.stream().map(DeliveryDetailDto::getDeliveryQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            Validate.isTrue((itemDtoTotalQuantity.compareTo(totalStock) < 1 ? 1 : 0) != 0, (String)String.format("%s\u8d85\u8fc7\u5b9e\u9645\u5e93\u5b58\u91cf\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
            Validate.isTrue((itemDtoTotalQuantity.compareTo(availableStock) < 1 ? 1 : 0) != 0, (String)String.format("%s\u8d85\u8fc7\u53ef\u7528\u5e93\u5b58\uff0c\u4e0d\u80fd\u521b\u5efa\u53d1\u8d27\u5355\uff01", tip), (Object[])new Object[0]);
        });
        this.deliveryDetailRepository.saveBatch(detailEntities);
        if (CollectionUtils.isEmpty(detailDeductEntities)) {
            return;
        }
        this.deliveryDetailDeductRepository.saveBatch(detailDeductEntities);
        this.changeWarehouse(deliveryDetailDtoList);
    }

    public List<DeliveryDetailVo> findByRelateCodesInAndGoodsCodesInAndBetweenStartTimeAndEndTime(DeliverySalesTargetDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            return Lists.newArrayList();
        }
        List<DeliveryDetailEntity> detailEntities = this.deliveryDetailRepository.findByRelateCodesInAndGoodsCodesInAndBetweenStartTimeAndEndTime(dto.getTenantCode(), dto.getCustomerCodes(), dto.getGoodsCodes(), dto.getStartTime(), dto.getEndTime());
        if (CollectionUtils.isEmpty(detailEntities)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailEntities, DeliveryDetailEntity.class, DeliveryDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void updateOutboundStatusByOutboundQuantity(String deliveryCode, String deliveryDetailCode, BigDecimal outboundQuantity, Boolean isAdd) {
        Validate.notBlank((CharSequence)deliveryCode, (String)"\u6839\u636e\u51fa\u5e93\u6570\u91cf\u4fee\u6539\u51fa\u5e93\u72b6\u6001\u65f6\uff0c\u6ca1\u6709\u4f20\u5165\u53d1\u8d27\u5355\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliveryDetailCode, (String)"\u6839\u636e\u51fa\u5e93\u6570\u91cf\u4fee\u6539\u51fa\u5e93\u72b6\u6001\u65f6\uff0c\u6ca1\u6709\u4f20\u5165\u53d1\u8d27\u5355\u884c\u7f16\u7801", (Object[])new Object[0]);
        Validate.notNull((Object)isAdd, (String)"\u6839\u636e\u51fa\u5e93\u6570\u91cf\u4fee\u6539\u51fa\u5e93\u72b6\u6001\u65f6\uff0c\u4e1a\u52a1\u6807\u8bc6\u6ca1\u4f20", (Object[])new Object[0]);
        Boolean isPositive = Objects.nonNull(outboundQuantity) && outboundQuantity.compareTo(BigDecimal.ZERO) == 1;
        Validate.isTrue((boolean)isPositive, (String)"\u6839\u636e\u51fa\u5e93\u6570\u91cf\u4fee\u6539\u51fa\u5e93\u72b6\u6001\u65f6\uff0c\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3001\u96f6\u3001\u8d1f\u6570", (Object[])new Object[0]);
        DeliveryDetailEntity detailEntity = this.deliveryDetailRepository.findByDeliveryCodeAndDeliveryDetailCode(TenantUtils.getTenantCode(), deliveryCode, deliveryDetailCode);
        Validate.notNull((Object)((Object)detailEntity), (String)"\u6839\u636e\u51fa\u5e93\u6570\u91cf\u4fee\u6539\u51fa\u5e93\u72b6\u6001\u65f6\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u4fe1\u606f", (Object[])new Object[0]);
        BigDecimal outboundQuantityDb = detailEntity.getOutboundQuantity();
        outboundQuantityDb = Objects.isNull(outboundQuantityDb) ? BigDecimal.ZERO : outboundQuantityDb;
        outboundQuantity = isAdd != false ? outboundQuantityDb.add(outboundQuantity) : outboundQuantityDb.subtract(outboundQuantity);
        int compareToZero = outboundQuantity.compareTo(BigDecimal.ZERO);
        Validate.isTrue((compareToZero > -1 ? 1 : 0) != 0, (String)"\u6839\u636e\u51fa\u5e93\u6570\u91cf\u4fee\u6539\u51fa\u5e93\u72b6\u6001\u65f6\uff0c\u5df2\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f", (Object[])new Object[0]);
        if (compareToZero == 0) {
            this.deliveryDetailRepository.updateOutboundStatusAndOutboundQuantityById(OutboundStatusEnum.START.getDictCode(), outboundQuantity, detailEntity.getId());
        } else {
            int compareToQuantity = outboundQuantity.compareTo(detailEntity.getDeliveryQuantity());
            Validate.isTrue((compareToQuantity <= 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u51fa\u5e93\u6570\u91cf\u4fee\u6539\u51fa\u5e93\u72b6\u6001\u65f6\uff0c\u5df2\u51fa\u5e93\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53d1\u8d27\u5355\u5546\u54c1\u603b\u91cf", (Object[])new Object[0]);
            if (compareToQuantity == 0) {
                this.deliveryDetailRepository.updateOutboundStatusAndOutboundQuantityById(OutboundStatusEnum.COMPLETE.getDictCode(), outboundQuantity, detailEntity.getId());
            } else {
                this.deliveryDetailRepository.updateOutboundStatusAndOutboundQuantityById(OutboundStatusEnum.PARTIAL.getDictCode(), outboundQuantity, detailEntity.getId());
            }
        }
    }

    @Transactional
    public void receivingDeliveryCodes(Set<String> deliveryCodes) {
        if (CollectionUtils.isEmpty(deliveryCodes)) {
            return;
        }
        List<DeliveryDetailEntity> detailEntities = this.deliveryDetailRepository.findByDeliveryCodes(TenantUtils.getTenantCode(), deliveryCodes);
        if (CollectionUtils.isEmpty(detailEntities)) {
            return;
        }
        detailEntities.forEach(de -> this.deliveryDetailRepository.receivingByDeliveryCode(de.getDeliveryCode(), de.getDeliveryQuantity()));
    }

    @Transactional
    public void updateEnableStatusByDeliveryCodes(Set<String> deliveryCodes, EnableStatusEnum enableStatus) {
        if (CollectionUtils.isEmpty(deliveryCodes)) {
            return;
        }
        this.deliveryDetailRepository.updateEnableStatusByDeliveryCodes(TenantUtils.getTenantCode(), deliveryCodes, enableStatus);
    }

    public void findDeductByDeliveryDetailVos(List<DeliveryDetailVo> deliveryDetailVos) {
        if (CollectionUtils.isEmpty(deliveryDetailVos)) {
            return;
        }
        List<String> deliveryCodes = deliveryDetailVos.stream().map(DeliveryDetailVo::getDeliveryCode).distinct().collect(Collectors.toList());
        List<DeliveryDetailDeductEntity> detailDeductEntities = this.deliveryDetailDeductRepository.findByDeliveryCodes(deliveryCodes);
        List detailDeductVos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(detailDeductEntities)) {
            detailDeductVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailDeductEntities, DeliveryDetailDeductEntity.class, DeliveryDetailDeductVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        Map<String, List<DeliveryDetailDeductVo>> detailPayMap = ((List)Optional.ofNullable(detailDeductVos).orElse(Lists.newArrayList())).stream().collect(Collectors.groupingBy(x -> StringUtils.join((Object[])new String[]{x.getDeliveryCode(), "_", x.getDeliveryDetailCode()})));
        deliveryDetailVos.forEach(o -> o.setDeliveryDetailDeductVos((List)detailPayMap.get(StringUtils.join((Object[])new String[]{o.getDeliveryCode(), "_", o.getDeliveryDetailCode()}))));
    }

    private Map<String, DeliveryStockVo> findDeliveryStockInfoMapByDeliveryDetailDtoList(List<DeliveryDetailDto> deliveryDetailDtoList) {
        if (CollectionUtils.isEmpty(deliveryDetailDtoList)) {
            return new HashMap<String, DeliveryStockVo>(0);
        }
        Map<String, Object> stockVoMap = new HashMap<String, DeliveryStockVo>(0);
        ArrayList deliveryStockDtoList = new ArrayList(deliveryDetailDtoList.size());
        String stockType = null;
        DeliveryDetailDto deliveryDetailDto = deliveryDetailDtoList.get(0);
        if (OrderCategoryEnum.SALES_ORDER.getDictCode().equals(deliveryDetailDto.getOrderCategory())) {
            stockType = StockType.PRODUCT.getDictCode();
        } else if (OrderCategoryEnum.MATERIAL_ORDER.getDictCode().equals(deliveryDetailDto.getOrderCategory())) {
            stockType = StockType.MATERIAL.getDictCode();
        }
        String finalStockType = stockType;
        Map<String, List<DeliveryDetailDto>> deliveryDetailDtoMap = deliveryDetailDtoList.stream().collect(Collectors.groupingBy(DeliveryDetailDto::getOrderCode));
        deliveryDetailDtoMap.forEach((orderCode, dd) -> {
            DeliveryStockDto deliveryStockDto = new DeliveryStockDto();
            deliveryStockDto.setStockType(finalStockType);
            deliveryStockDto.setOrderCode(orderCode);
            Set goodsCodes = dd.stream().map(DeliveryDetailDto::getGoodsCode).collect(Collectors.toSet());
            deliveryStockDto.setProductCodes(goodsCodes);
            deliveryStockDtoList.add(deliveryStockDto);
        });
        try {
            List result = this.deliveryStockVoService.findByDeliveryMaterialStockDto(deliveryStockDtoList);
            stockVoMap = ((List)Optional.ofNullable(result).orElse(new ArrayList())).stream().collect(Collectors.toMap(x -> StringUtils.join((Object[])new String[]{x.getOrderCode(), "_", x.getWarehouseCode(), "_", x.getProductCode()}), Function.identity()));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e93\u5b58\u65f6\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return stockVoMap;
    }

    private Map<String, List<DeliveryStockVo>> findDeliveryStockByOrderVos(List<OrderVo> orderVos) {
        if (CollectionUtils.isEmpty(orderVos)) {
            return new HashMap<String, List<DeliveryStockVo>>(0);
        }
        ArrayList deliveryStockDtoList = new ArrayList(orderVos.size());
        orderVos.forEach(orderVo -> orderVo.getOrderDetails().forEach(od -> {
            DeliveryStockDto deliveryStockDto = new DeliveryStockDto();
            deliveryStockDto.setOrderCode(orderVo.getOrderCode());
            deliveryStockDto.setCityCode(orderVo.getCityCode());
            deliveryStockDto.setOrderItemCode(od.getOrderDetailCode());
            deliveryStockDtoList.add(deliveryStockDto);
        }));
        Map<String, List<DeliveryStockVo>> deliveryStockVoMap = new HashMap<String, List<DeliveryStockVo>>();
        try {
            List result = this.deliveryStockVoService.findByOrderCodeAndItemCode(deliveryStockDtoList);
            log.info("\u67e5\u8be2\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)result);
            ArrayList deliveryStockVos = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                Map<String, List<DeliveryStockVo>> handlerDeliveryStockVoMap = result.stream().collect(Collectors.groupingBy(x -> StringUtils.join((Object[])new String[]{x.getOrderCode(), "_", x.getOrderItemCode(), "_", x.getWarehouseCode()})));
                handlerDeliveryStockVoMap.forEach((k, ds) -> {
                    BigDecimal frozenQuantity = ds.stream().map(DeliveryStockVo::getFrozenQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    DeliveryStockVo deliveryStockVo = (DeliveryStockVo)ds.get(0);
                    deliveryStockVo.setFrozenQuantity(frozenQuantity);
                    deliveryStockVos.add(deliveryStockVo);
                });
            }
            deliveryStockVoMap = deliveryStockVos.stream().collect(Collectors.groupingBy(x -> StringUtils.join((Object[])new String[]{x.getOrderCode(), "_", x.getOrderItemCode()})));
            log.info("\u67e5\u8be2\u5e93\u5b58\u5206\u7ec4\u7edf\u8ba1\u7ed3\u679c\uff1a{}", deliveryStockVoMap);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e93\u5b58\u65f6\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return deliveryStockVoMap;
    }

    private void changeWarehouse(List<DeliveryDetailDto> deliveryDetailDtoList) {
        ArrayList frozenList = Lists.newArrayListWithCapacity((int)deliveryDetailDtoList.size());
        ArrayList thawList = Lists.newArrayListWithCapacity((int)deliveryDetailDtoList.size());
        for (DeliveryDetailDto deliveryDetailDto : deliveryDetailDtoList) {
            if (StringUtils.equals((CharSequence)deliveryDetailDto.getHistoryWarehouseCode(), (CharSequence)deliveryDetailDto.getCurrentWarehouseCode())) {
                log.info("\u521b\u5efa\u53d1\u8d27\u5355\u65f6\u672a\u6539\u4ed3\uff1a\u4e0d\u505a\u4efb\u4f55\u5e93\u5b58\u64cd\u4f5c");
                continue;
            }
            ProductStockOperationDto productStockOperationDto1 = new ProductStockOperationDto();
            productStockOperationDto1.setWarehouseCode(deliveryDetailDto.getHistoryWarehouseCode());
            productStockOperationDto1.setWarehouseName(deliveryDetailDto.getHistoryWarehouseName());
            productStockOperationDto1.setProductCode(deliveryDetailDto.getGoodsCode());
            productStockOperationDto1.setProductName(deliveryDetailDto.getGoodsName());
            productStockOperationDto1.setProductStockOperationType(ProductStockOperationType.ORDER_CHANGE_WAREHOUSE_UNFREEZE.getDictCode());
            productStockOperationDto1.setCustomerCode(deliveryDetailDto.getRelateCode());
            productStockOperationDto1.setCustomerName(deliveryDetailDto.getRelateName());
            productStockOperationDto1.setOriginalOrderCode(deliveryDetailDto.getOriginalOrderCode());
            productStockOperationDto1.setOrderType(deliveryDetailDto.getOrderType());
            productStockOperationDto1.setOrderCode(deliveryDetailDto.getOrderCode());
            productStockOperationDto1.setOrderItemCode(deliveryDetailDto.getOrderDetailCode());
            productStockOperationDto1.setQuantity(deliveryDetailDto.getDeliveryQuantity());
            thawList.add(productStockOperationDto1);
            ProductStockOperationDto productStockOperationDto2 = new ProductStockOperationDto();
            productStockOperationDto2.setWarehouseCode(deliveryDetailDto.getCurrentWarehouseCode());
            productStockOperationDto2.setWarehouseName(deliveryDetailDto.getCurrentWarehouseName());
            productStockOperationDto2.setProductCode(deliveryDetailDto.getGoodsCode());
            productStockOperationDto2.setProductName(deliveryDetailDto.getGoodsName());
            productStockOperationDto2.setProductStockOperationType(ProductStockOperationType.ORDER_CHANGE_WAREHOUSE_FREEZING.getDictCode());
            productStockOperationDto2.setCustomerCode(deliveryDetailDto.getRelateCode());
            productStockOperationDto2.setCustomerName(deliveryDetailDto.getRelateName());
            productStockOperationDto2.setOriginalOrderCode(deliveryDetailDto.getOriginalOrderCode());
            productStockOperationDto2.setOrderType(deliveryDetailDto.getOrderType());
            productStockOperationDto2.setOrderCode(deliveryDetailDto.getOrderCode());
            productStockOperationDto2.setOrderItemCode(deliveryDetailDto.getOrderDetailCode());
            productStockOperationDto2.setQuantity(deliveryDetailDto.getDeliveryQuantity());
            frozenList.add(productStockOperationDto2);
        }
        if (CollectionUtils.isNotEmpty((Collection)frozenList)) {
            log.info("\u65b0\u589e\u53d1\u8d27\u5355\u65f6\u6267\u884c\u6539\u4ed3\u903b\u8f91\u7684\u51bb\u7ed3\u5e93\u5b58\uff1afrozenList={}", (Object)frozenList);
            this.productStockVoService.frozenBatch((List)frozenList);
        }
        if (CollectionUtils.isNotEmpty((Collection)thawList)) {
            log.info("\u65b0\u589e\u53d1\u8d27\u5355\u65f6\u6267\u884c\u6539\u4ed3\u903b\u8f91\u7684\u89e3\u51bb\u5e93\u5b58\uff1athawList={}", (Object)thawList);
            this.productStockVoService.thawBatch((List)thawList);
        }
    }
}

