/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryDetailEntity;
import com.biz.crm.dms.business.delivery.local.repository.DeliveryDetailRepository;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryUnshippedVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryUnshippedVo;
import com.biz.crm.dms.business.order.common.sdk.enums.MaterielOrderTypeEnum;
import com.biz.crm.dms.business.order.sdk.dto.OrderUnshippedPageDto;
import com.biz.crm.dms.business.order.sdk.service.OrderUnshippedVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderUnshippedVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DeliveryUnshippedVoServiceImpl
implements DeliveryUnshippedVoService {
    private static final Logger log = LoggerFactory.getLogger(DeliveryUnshippedVoServiceImpl.class);
    @Autowired(required=false)
    private OrderUnshippedVoService orderUnshippedVoService;
    @Autowired(required=false)
    private DeliveryDetailRepository deliveryDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<DeliveryUnshippedVo> findByOrderUnshippedPageDto(Pageable pageable, DeliveryUnshippedPageDto deliveryUnshippedPageDto) {
        if (Objects.isNull(deliveryUnshippedPageDto)) {
            deliveryUnshippedPageDto = new DeliveryUnshippedPageDto();
        }
        OrderUnshippedPageDto order = new OrderUnshippedPageDto();
        order.setOrderCategory(deliveryUnshippedPageDto.getOrderCategory());
        order.setOrderCode(deliveryUnshippedPageDto.getOrderCode());
        order.setOrderCodes(deliveryUnshippedPageDto.getOrderCodes());
        order.setRelateCode(deliveryUnshippedPageDto.getRelateCode());
        order.setRelateName(deliveryUnshippedPageDto.getRelateName());
        order.setOrderStatus(deliveryUnshippedPageDto.getOrderStatus());
        order.setOrderType(deliveryUnshippedPageDto.getOrderType());
        Page orderPage = this.orderUnshippedVoService.findByOrderUnshippedPageDto(pageable, order);
        if (orderPage == null || CollectionUtils.isEmpty((Collection)orderPage.getRecords())) {
            return new Page();
        }
        List records = orderPage.getRecords();
        List deliveryUnshippedVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)records, OrderUnshippedVo.class, DeliveryUnshippedVo.class, HashSet.class, LinkedList.class, new String[0]);
        Set<String> orderCodes = deliveryUnshippedVos.stream().map(DeliveryUnshippedVo::getOrderCode).collect(Collectors.toSet());
        List<DeliveryDetailEntity> recordDetails = this.deliveryDetailRepository.findByOrderCodes(TenantUtils.getTenantCode(), orderCodes);
        Map<String, List<DeliveryDetailEntity>> recordDetailMap = recordDetails.stream().collect(Collectors.groupingBy(DeliveryDetailEntity::getOrderCode));
        deliveryUnshippedVos.forEach(o -> {
            if (MaterielOrderTypeEnum.ORGANIZATION.getDictCode().equals(o.getOrderType())) {
                if (StringUtils.isNotBlank((CharSequence)o.getRelateCode())) {
                    o.setOrgCode(o.getRelateCode());
                    o.setRelateCode(null);
                }
                if (StringUtils.isNotBlank((CharSequence)o.getRelateName())) {
                    o.setOrgName(o.getRelateName());
                    o.setRelateName(null);
                }
            }
            o.setDeliveryQuantity(o.getDeliveryQuantity() != null ? o.getDeliveryQuantity() : BigDecimal.ZERO);
            if (o.getQuantityOfCommodity() == null) {
                log.error("\u8ba2\u5355\u53f7{}\u5bf9\u5e94\u7684\u5546\u54c1\u6570\u91cf\u5b57\u6bb5[quantityOfCommodity]\u4e3a\u7a7a\uff0c\u5c5e\u4e8e\u5f02\u5e38\u60c5\u51b5\uff0c\u8bf7\u8ba2\u5355\u6a21\u5757\u68c0\u67e5\u4ee3\u7801\u903b\u8f91\uff01\uff01\uff01", (Object)o.getOrderCode());
                return;
            }
            List detailEntities = (List)recordDetailMap.get(o.getOrderCode());
            if (CollectionUtils.isEmpty((Collection)detailEntities)) {
                o.setResidualDeliveryQuantity(o.getQuantityOfCommodity());
            } else {
                BigDecimal totalDeliveryQuantity = Optional.ofNullable(detailEntities).orElse(Lists.newArrayList()).stream().map(DeliveryDetailEntity::getDeliveryQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                o.setResidualDeliveryQuantity(o.getQuantityOfCommodity().subtract(totalDeliveryQuantity));
            }
        });
        Page deliveryUnshippedVoPage = new Page(orderPage.getCurrent(), orderPage.getSize(), orderPage.getTotal());
        deliveryUnshippedVoPage.setRecords(deliveryUnshippedVos);
        return deliveryUnshippedVoPage;
    }
}

