/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryAttachmentEntity;
import com.biz.crm.dms.business.delivery.local.entity.DeliveryEntity;
import com.biz.crm.dms.business.delivery.local.repository.DeliveryAttachmentRepository;
import com.biz.crm.dms.business.delivery.local.repository.DeliveryRepository;
import com.biz.crm.dms.business.delivery.local.repository.DeliveryVoRepository;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryAttachmentDto;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryDetailDto;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryDto;
import com.biz.crm.dms.business.delivery.sdk.enums.InvoiceStatusEnum;
import com.biz.crm.dms.business.delivery.sdk.enums.OutboundStatusEnum;
import com.biz.crm.dms.business.delivery.sdk.enums.ReceiptStatusEnum;
import com.biz.crm.dms.business.delivery.sdk.event.DeliveryEventListener;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryAttachmentVo;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryDetailVo;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryVo;
import com.biz.crm.dms.business.order.common.sdk.enums.MaterielOrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillCreateDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillDetailDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.AssociatedDocumentsType;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperationType;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.StockType;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductDeliveryBillVoService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeliveryVoServiceImpl
implements DeliveryVoService {
    private static final Logger log = LoggerFactory.getLogger(DeliveryVoServiceImpl.class);
    @Autowired(required=false)
    private DeliveryRepository deliveryRepository;
    @Autowired(required=false)
    private DeliveryVoRepository deliveryVoRepository;
    @Autowired(required=false)
    private DeliveryAttachmentRepository deliveryAttachmentRepository;
    @Autowired(required=false)
    private DeliveryDetailVoService deliveryDetailVoService;
    @Autowired(required=false)
    private ProductDeliveryBillVoService productDeliveryBillVoService;
    @Autowired(required=false)
    private OrderVoService orderVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<DeliveryEventListener> deliveryEventListeners;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public Page<DeliveryVo> findByConditions(Pageable pageable, DeliveryDto dto) {
        Page<DeliveryVo> deliveryVoPage = this.deliveryVoRepository.findByConditions(pageable, dto);
        if (deliveryVoPage.getTotal() == 0L) {
            return deliveryVoPage;
        }
        Set deliveryCodes = deliveryVoPage.getRecords().stream().map(DeliveryVo::getDeliveryCode).collect(Collectors.toSet());
        List detailVos = this.deliveryDetailVoService.findByDeliveryCodes(deliveryCodes);
        Map<String, List<DeliveryDetailVo>> detailMap = detailVos.stream().collect(Collectors.groupingBy(DeliveryDetailVo::getDeliveryCode));
        deliveryVoPage.getRecords().forEach(deliveryVo -> {
            List deliveryDetailVos = (List)detailMap.get(deliveryVo.getDeliveryCode());
            if (CollectionUtils.isNotEmpty((Collection)deliveryDetailVos)) {
                BigDecimal totalDeliveryQuantity = Optional.ofNullable(deliveryDetailVos).orElse(Lists.newArrayList()).stream().map(DeliveryDetailVo::getDeliveryQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalDeliverAmount = Optional.ofNullable(deliveryDetailVos).orElse(Lists.newArrayList()).stream().map(DeliveryDetailVo::getDeliverAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                deliveryVo.setTotalDeliveryQuantity(totalDeliveryQuantity);
                deliveryVo.setTotalDeliverAmount(totalDeliverAmount);
            }
            this.buildDeliveryHeadInfo((DeliveryVo)deliveryVo, deliveryDetailVos);
        });
        return deliveryVoPage;
    }

    public DeliveryVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DeliveryEntity entity = (DeliveryEntity)((Object)this.deliveryRepository.getById((Serializable)((Object)id)));
        if (entity == null) {
            return null;
        }
        DeliveryVo deliveryVo = (DeliveryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DeliveryVo.class, HashSet.class, ArrayList.class, new String[0]);
        List deliveryDetailVos = this.deliveryDetailVoService.findDetailByDeliveryCodes(Collections.singleton(deliveryVo.getDeliveryCode()));
        deliveryVo.setDeliveryDetailVos(deliveryDetailVos);
        if (CollectionUtils.isNotEmpty((Collection)deliveryDetailVos)) {
            BigDecimal totalDeliveryQuantity = Optional.ofNullable(deliveryDetailVos).orElse(Lists.newArrayList()).stream().map(DeliveryDetailVo::getDeliveryQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalDeliverAmount = Optional.ofNullable(deliveryDetailVos).orElse(Lists.newArrayList()).stream().map(DeliveryDetailVo::getDeliverAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            deliveryVo.setTotalDeliveryQuantity(totalDeliveryQuantity);
            deliveryVo.setTotalDeliverAmount(totalDeliverAmount);
        }
        this.buildDeliveryHeadInfo(deliveryVo, deliveryDetailVos);
        this.buildPictureMediaList(deliveryDetailVos);
        List<DeliveryAttachmentEntity> attachmentEntities = this.deliveryAttachmentRepository.findByDeliveryCodes(TenantUtils.getTenantCode(), Collections.singleton(deliveryVo.getDeliveryCode()));
        if (CollectionUtils.isEmpty(attachmentEntities)) {
            return deliveryVo;
        }
        List attachmentVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(attachmentEntities, DeliveryAttachmentEntity.class, DeliveryAttachmentVo.class, HashSet.class, ArrayList.class, new String[0]);
        deliveryVo.setDeliveryAttachmentVos(attachmentVos);
        return deliveryVo;
    }

    @Transactional
    public void create(DeliveryDto dto) {
        this.createValidation(dto);
        String ruleCode = StringUtils.join((Object[])new String[]{"FHD", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)codeList), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u53d1\u8d27\u5355\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        dto.setDeliveryCode((String)codeList.get(0));
        DeliveryEntity dbEntity = this.deliveryRepository.findByDeliveryCode(TenantUtils.getTenantCode(), (String)codeList.get(0));
        Validate.isTrue((boolean)Objects.isNull((Object)dbEntity), (String)String.format("\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d1\u8d27\u5355\u7f16\u7801[%s]\u5df2\u5b58\u5728\uff01", codeList.get(0)), (Object[])new Object[0]);
        DeliveryEntity entity = (DeliveryEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DeliveryEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setReceiptStatus(ReceiptStatusEnum.START.getDictCode());
        this.deliveryRepository.save((Object)entity);
        this.saveBatchDeliveryDetail(entity, dto.getDeliveryDetailDtoList());
        this.saveBatchDeliveryAttachment(entity, dto.getDeliveryAttachmentDtoList());
        this.increaseOrderDelivery(dto.getDeliveryDetailDtoList());
        if (!CollectionUtils.isEmpty(this.deliveryEventListeners)) {
            this.deliveryEventListeners.forEach(deliveryEventListener -> deliveryEventListener.onCreated(dto));
        }
    }

    @Transactional
    public void createDeliveryAndOutbound(DeliveryDto dto) {
        this.create(dto);
        this.createOutbound(dto);
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DeliveryEntity> entities = this.deliveryRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.deliveryRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DeliveryEntity> entities = this.deliveryRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        List<DeliveryEntity> enableEntities = entities.stream().filter(e -> EnableStatusEnum.ENABLE.getCode().equals(e.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(enableEntities)) {
            return;
        }
        Set deliveryCodes = enableEntities.stream().map(DeliveryEntity::getDeliveryCode).collect(Collectors.toSet());
        List deliveryDetailVos = this.deliveryDetailVoService.findDetailByDeliveryCodes(deliveryCodes);
        Optional<DeliveryDetailVo> optional = Optional.ofNullable(deliveryDetailVos).orElse(Lists.newArrayList()).stream().filter(e -> !InvoiceStatusEnum.START.getDictCode().equals(e.getInvoiceStatus()) || !OutboundStatusEnum.START.getDictCode().equals(e.getOutboundStatus())).findAny();
        Validate.isTrue((!optional.isPresent() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u4f5c\u5e9f\u5f85\u51fa\u5e93\u4e14\u5f85\u5f00\u7968\u7684\u53d1\u8d27\u5355\uff01", (Object[])new Object[0]);
        this.deliveryRepository.updateEnableStatusByIds(enableEntities.stream().map(UuidEntity::getId).collect(Collectors.toList()), EnableStatusEnum.DISABLE);
        this.deliveryDetailVoService.updateEnableStatusByDeliveryCodes(deliveryCodes, EnableStatusEnum.DISABLE);
        this.reduceOrderDelivery(enableEntities);
        if (!CollectionUtils.isEmpty(this.deliveryEventListeners)) {
            List deliveryVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(enableEntities, DeliveryEntity.class, DeliveryVo.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<DeliveryDetailVo>> deliveryDetailMap = Optional.ofNullable(deliveryDetailVos).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(DeliveryDetailVo::getDeliveryCode));
            deliveryVos.forEach(d -> d.setDeliveryDetailVos((List)deliveryDetailMap.get(d.getDeliveryCode())));
            this.deliveryEventListeners.forEach(deliveryEventListener -> deliveryEventListener.onDisabled(deliveryVos));
        }
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DeliveryEntity> entities = this.deliveryRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        Optional<DeliveryEntity> optional = entities.stream().filter(e -> EnableStatusEnum.DISABLE.getCode().equals(e.getEnableStatus())).findAny();
        Validate.isTrue((boolean)optional.isPresent(), (String)"\u53ea\u80fd\u5220\u9664\u5df2\u4f5c\u5e9f\u7684\u53d1\u8d27\u5355\uff01", (Object[])new Object[0]);
        this.deliveryRepository.updateDelFlagByIds(ids);
        if (!CollectionUtils.isEmpty(this.deliveryEventListeners)) {
            List deliveryVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DeliveryEntity.class, DeliveryVo.class, HashSet.class, ArrayList.class, new String[0]);
            Set deliveryCodes = deliveryVos.stream().map(DeliveryVo::getDeliveryCode).collect(Collectors.toSet());
            List deliveryDetailVos = this.deliveryDetailVoService.findDetailByDeliveryCodes(deliveryCodes);
            Map<String, List<DeliveryDetailVo>> deliveryDetailMap = Optional.ofNullable(deliveryDetailVos).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(DeliveryDetailVo::getDeliveryCode));
            deliveryVos.forEach(d -> d.setDeliveryDetailVos((List)deliveryDetailMap.get(d.getDeliveryCode())));
            this.deliveryEventListeners.forEach(deliveryEventListener -> deliveryEventListener.onDeleted(deliveryVos));
        }
    }

    @Transactional
    public void receivingByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DeliveryEntity> entities = this.deliveryRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.deliveryRepository.receivingByIds(ids);
        Set deliveryCodes = entities.stream().map(DeliveryEntity::getDeliveryCode).collect(Collectors.toSet());
        this.deliveryDetailVoService.receivingDeliveryCodes(deliveryCodes);
        if (!CollectionUtils.isEmpty(this.deliveryEventListeners)) {
            List deliveryVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DeliveryEntity.class, DeliveryVo.class, HashSet.class, ArrayList.class, new String[0]);
            List deliveryDetailVos = this.deliveryDetailVoService.findDetailByDeliveryCodes(deliveryCodes);
            Map<String, List<DeliveryDetailVo>> deliveryDetailMap = Optional.ofNullable(deliveryDetailVos).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(DeliveryDetailVo::getDeliveryCode));
            deliveryVos.forEach(d -> d.setDeliveryDetailVos((List)deliveryDetailMap.get(d.getDeliveryCode())));
            this.deliveryEventListeners.forEach(deliveryEventListener -> deliveryEventListener.onReceived(deliveryVos));
        }
    }

    public List<DeliveryVo> findByOrderCode(String orderCode) {
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return null;
        }
        List deliveryDetailVos = this.deliveryDetailVoService.findByOrderCodes(Collections.singleton(orderCode));
        if (CollectionUtils.isEmpty((Collection)deliveryDetailVos)) {
            return null;
        }
        Map<String, List<DeliveryDetailVo>> detailVoMap = deliveryDetailVos.stream().collect(Collectors.groupingBy(DeliveryDetailVo::getDeliveryCode));
        Set<String> deliveryCodes = deliveryDetailVos.stream().map(DeliveryDetailVo::getDeliveryCode).collect(Collectors.toSet());
        List<DeliveryEntity> deliveryEntities = this.deliveryRepository.findByDeliveryCodes(deliveryCodes);
        if (CollectionUtils.isEmpty(deliveryEntities)) {
            return null;
        }
        List deliveryVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(deliveryEntities, DeliveryEntity.class, DeliveryVo.class, HashSet.class, ArrayList.class, new String[0]);
        List orderVos = this.orderVoService.findByOrderCodes(Collections.singletonList(orderCode));
        Map orderMap = orderVos.stream().collect(Collectors.toMap(OrderVo::getOrderCode, Function.identity()));
        deliveryVos.forEach(deliveryVo -> {
            List detailVoList = (List)detailVoMap.get(deliveryVo.getDeliveryCode());
            if (CollectionUtils.isNotEmpty((Collection)detailVoList)) {
                detailVoList.forEach(deliveryDetailVo -> {
                    OrderVo orderVo = (OrderVo)orderMap.get(deliveryDetailVo.getOrderCode());
                    List orderDetailVos = orderVo.getOrderDetails();
                    Map orderDetailVoMap = ((List)Optional.ofNullable(orderDetailVos).orElse(new ArrayList())).stream().collect(Collectors.toMap(d -> d.getOrderCode() + "_" + d.getOrderDetailCode(), Function.identity()));
                    OrderDetailVo orderDetailVo = (OrderDetailVo)orderDetailVoMap.get(deliveryDetailVo.getOrderCode() + "_" + deliveryDetailVo.getOrderDetailCode());
                    if (orderDetailVo != null) {
                        deliveryDetailVo.setDeliverSalesAmount(deliveryDetailVo.getDeliveryQuantity().divide(orderDetailVo.getQuantity(), 4, RoundingMode.HALF_UP).multiply(orderDetailVo.getSalesAmount()));
                        deliveryDetailVo.setDeliverShouldPaymentAmount(deliveryDetailVo.getDeliveryQuantity().divide(orderDetailVo.getQuantity(), 4, RoundingMode.HALF_UP).multiply(orderDetailVo.getShouldPaymentAmount()));
                        deliveryDetailVo.setOrderType(orderVo.getOrderType());
                        deliveryDetailVo.setOriginalOrderCode(orderVo.getOriginalOrderCode());
                        deliveryDetailVo.setGoodsCode(orderDetailVo.getGoodsCode());
                        deliveryDetailVo.setGoodsName(orderDetailVo.getGoodsName());
                        deliveryDetailVo.setItemType(orderDetailVo.getItemType());
                        deliveryDetailVo.setPresetUnitPrice(orderDetailVo.getPresetUnitPrice());
                        deliveryDetailVo.setShouldPaymentAmount(orderDetailVo.getShouldPaymentAmount());
                        deliveryDetailVo.setSalesAmount(orderDetailVo.getSalesAmount());
                        deliveryDetailVo.setQuantity(orderDetailVo.getQuantity());
                        deliveryDetailVo.setUnite(orderDetailVo.getUnite());
                        deliveryDetailVo.setSpec(orderDetailVo.getSpec());
                    }
                });
            }
            this.buildDeliveryHeadInfo((DeliveryVo)deliveryVo, detailVoList);
            this.buildPictureMediaList(detailVoList);
            deliveryVo.setDeliveryDetailVos(detailVoList);
        });
        return deliveryVos;
    }

    private void buildPictureMediaList(List<DeliveryDetailVo> deliveryDetailVos) {
        if (CollectionUtils.isEmpty(deliveryDetailVos)) {
            return;
        }
        List productCodes = deliveryDetailVos.stream().map(DeliveryDetailVo::getGoodsCode).distinct().collect(Collectors.toList());
        List productList = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodes);
        if (CollectionUtils.isEmpty((Collection)productList)) {
            return;
        }
        Map productVoMap = productList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        deliveryDetailVos.forEach(dd -> {
            ProductVo productVo = (ProductVo)productVoMap.get(dd.getGoodsCode());
            if (productVo != null) {
                dd.setPictureMediaList(productVo.getPictureMediaList());
            }
        });
    }

    private void buildDeliveryHeadInfo(DeliveryVo deliveryVo, List<DeliveryDetailVo> deliveryDetailVos) {
        if (CollectionUtils.isEmpty(deliveryDetailVos)) {
            return;
        }
        HashSet orderTypes = new HashSet(deliveryDetailVos.size());
        HashSet orderCodes = new HashSet(deliveryDetailVos.size());
        HashSet outboundCodes = new HashSet(deliveryDetailVos.size());
        HashSet outboundStatus = new HashSet(deliveryDetailVos.size());
        HashSet invoiceStatus = new HashSet(deliveryDetailVos.size());
        HashSet relateCodes = new HashSet(deliveryDetailVos.size());
        HashSet relateNames = new HashSet(deliveryDetailVos.size());
        HashSet orgCodes = new HashSet(deliveryDetailVos.size());
        HashSet orgNames = new HashSet(deliveryDetailVos.size());
        AtomicReference<Boolean> isPendingOutbound = new AtomicReference<Boolean>(Boolean.TRUE);
        AtomicReference<Boolean> isCompletelyOutbound = new AtomicReference<Boolean>(Boolean.TRUE);
        deliveryDetailVos.forEach(dd -> {
            if (StringUtils.isNotBlank((CharSequence)dd.getOrderType())) {
                orderTypes.add(dd.getOrderType());
            }
            if (StringUtils.isNotBlank((CharSequence)dd.getOrderCode())) {
                orderCodes.add(dd.getOrderCode());
            }
            if (StringUtils.isNotBlank((CharSequence)dd.getOutboundCode())) {
                outboundCodes.add(dd.getOutboundCode());
            }
            if (StringUtils.isNotBlank((CharSequence)dd.getOutboundStatus())) {
                outboundStatus.add(dd.getOutboundStatus());
                OutboundStatusEnum outboundStatusEnum = OutboundStatusEnum.codeToEnum((String)dd.getOutboundStatus());
                switch (outboundStatusEnum) {
                    case START: {
                        isCompletelyOutbound.set(Boolean.FALSE);
                        break;
                    }
                    case PARTIAL: {
                        isCompletelyOutbound.set(Boolean.FALSE);
                        isPendingOutbound.set(Boolean.FALSE);
                        break;
                    }
                    case COMPLETE: {
                        isPendingOutbound.set(Boolean.FALSE);
                        break;
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dd.getInvoiceStatus())) {
                invoiceStatus.add(dd.getInvoiceStatus());
            }
            if (MaterielOrderTypeEnum.ORGANIZATION.getDictCode().equals(dd.getOrderType())) {
                if (StringUtils.isNotBlank((CharSequence)dd.getRelateCode())) {
                    orgCodes.add(dd.getRelateCode());
                }
                if (StringUtils.isNotBlank((CharSequence)dd.getRelateName())) {
                    orgNames.add(dd.getRelateName());
                }
                if (StringUtils.isNotBlank((CharSequence)dd.getOrgCode())) {
                    orgCodes.add(dd.getOrgCode());
                }
                if (StringUtils.isNotBlank((CharSequence)dd.getOrgName())) {
                    orgNames.add(dd.getOrgName());
                }
            } else {
                if (StringUtils.isNotBlank((CharSequence)dd.getRelateCode())) {
                    relateCodes.add(dd.getRelateCode());
                }
                if (StringUtils.isNotBlank((CharSequence)dd.getRelateName())) {
                    relateNames.add(dd.getRelateName());
                }
            }
        });
        if (isCompletelyOutbound.get().booleanValue()) {
            deliveryVo.setOutboundStatus(OutboundStatusEnum.COMPLETE.getDictCode());
        } else if (isPendingOutbound.get().booleanValue()) {
            deliveryVo.setOutboundStatus(OutboundStatusEnum.START.getDictCode());
        } else {
            deliveryVo.setOutboundStatus(OutboundStatusEnum.PARTIAL.getDictCode());
        }
        deliveryVo.setOrderType(StringUtils.join((Object[])orderTypes.toArray(), (String)","));
        deliveryVo.setOrderCodes(StringUtils.join((Object[])orderCodes.toArray(), (String)","));
        deliveryVo.setOutboundCodes(StringUtils.join((Object[])outboundCodes.toArray(), (String)","));
        deliveryVo.setInvoiceStatus(StringUtils.join((Object[])invoiceStatus.toArray(), (String)","));
        deliveryVo.setRelateCodes(StringUtils.join((Object[])relateCodes.toArray(), (String)","));
        deliveryVo.setRelateNames(StringUtils.join((Object[])relateNames.toArray(), (String)","));
        deliveryVo.setOrgCodes(StringUtils.join((Object[])orgCodes.toArray(), (String)","));
        deliveryVo.setOrgNames(StringUtils.join((Object[])orgNames.toArray(), (String)","));
    }

    private void saveBatchDeliveryDetail(DeliveryEntity entity, List<DeliveryDetailDto> deliveryDetailDtoList) {
        String ruleCode = StringUtils.join((Object[])new String[]{"FHG", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, deliveryDetailDtoList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)codeList), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u53d1\u8d27\u5355\u884c\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        int deliveryDetailDtoListSize = deliveryDetailDtoList.size();
        for (int i = 0; i < deliveryDetailDtoListSize; ++i) {
            DeliveryDetailDto detailDto = deliveryDetailDtoList.get(i);
            detailDto.setTenantCode(entity.getTenantCode());
            detailDto.setDeliveryCode(entity.getDeliveryCode());
            detailDto.setDeliveryDetailCode((String)codeList.get(i));
            detailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detailDto.setOutboundStatus(OutboundStatusEnum.START.getDictCode());
            detailDto.setInvoiceStatus(InvoiceStatusEnum.START.getDictCode());
            detailDto.setOrderCategory(entity.getOrderCategory());
        }
        this.deliveryDetailVoService.createBatch(deliveryDetailDtoList);
    }

    private void saveBatchDeliveryAttachment(DeliveryEntity entity, List<DeliveryAttachmentDto> deliveryAttachmentDtoList) {
        if (CollectionUtils.isEmpty(deliveryAttachmentDtoList)) {
            return;
        }
        ArrayList attachmentEntities = Lists.newArrayList();
        deliveryAttachmentDtoList.forEach(d -> {
            DeliveryAttachmentEntity dimensionEntity = new DeliveryAttachmentEntity();
            dimensionEntity.setTenantCode(entity.getTenantCode());
            dimensionEntity.setDeliveryCode(entity.getDeliveryCode());
            dimensionEntity.setFileType(d.getFileType());
            attachmentEntities.add(dimensionEntity);
        });
        if (CollectionUtils.isEmpty((Collection)attachmentEntities)) {
            return;
        }
        this.deliveryAttachmentRepository.saveBatch(attachmentEntities);
    }

    private void increaseOrderDelivery(List<DeliveryDetailDto> detailDtoList) {
        if (CollectionUtils.isEmpty(detailDtoList)) {
            return;
        }
        Map<String, List<DeliveryDetailDto>> deliveryDetailMap = detailDtoList.stream().collect(Collectors.groupingBy(DeliveryDetailDto::getOrderCode));
        deliveryDetailMap.forEach((orderCode, deliveryDetailDtoList) -> {
            BigDecimal totalDeliveryQuantity = Optional.ofNullable(deliveryDetailDtoList).orElse(Lists.newArrayList()).stream().map(DeliveryDetailDto::getDeliveryQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimal.ZERO.compareTo(totalDeliveryQuantity) < 1) {
                log.info("\u4f5c\u5e9f\u53d1\u8d27\u5355\u65f6\u589e\u52a0\u8ba2\u5355{}\u53d1\u8d27\u6570\u91cf{}\u53ca\u72b6\u6001\u66f4\u65b0", orderCode, (Object)totalDeliveryQuantity);
                this.orderVoService.updateOrderStatusByDeliveryQuantity(orderCode, totalDeliveryQuantity, Boolean.TRUE);
            }
        });
    }

    private void reduceOrderDelivery(List<DeliveryEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        Set deliveryCodes = entities.stream().map(DeliveryEntity::getDeliveryCode).collect(Collectors.toSet());
        List deliveryDetailVos = this.deliveryDetailVoService.findByDeliveryCodes(deliveryCodes);
        Map<String, List<DeliveryDetailVo>> deliveryDetailMap = deliveryDetailVos.stream().collect(Collectors.groupingBy(DeliveryDetailVo::getOrderCode));
        deliveryDetailMap.forEach((orderCode, deliveryDetailVoList) -> {
            BigDecimal totalDeliveryQuantity = Optional.ofNullable(deliveryDetailVoList).orElse(Lists.newArrayList()).stream().map(DeliveryDetailVo::getDeliveryQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimal.ZERO.compareTo(totalDeliveryQuantity) < 1) {
                log.info("\u4f5c\u5e9f\u53d1\u8d27\u5355\u65f6\u51cf\u5c11\u8ba2\u5355{}\u53d1\u8d27\u6570\u91cf{}\u53ca\u72b6\u6001\u66f4\u65b0", orderCode, (Object)totalDeliveryQuantity);
                this.orderVoService.updateOrderStatusByDeliveryQuantity(orderCode, totalDeliveryQuantity, Boolean.FALSE);
            }
        });
    }

    private void createOutbound(DeliveryDto dto) {
        List deliveryDetailDtoList = dto.getDeliveryDetailDtoList();
        Map<String, List<DeliveryDetailDto>> detailMap = deliveryDetailDtoList.stream().collect(Collectors.groupingBy(DeliveryDetailDto::getCurrentWarehouseCode));
        detailMap.forEach((warehouseCode, itemDetailDtoList) -> {
            ProductDeliveryBillCreateDto productDeliveryBillCreateDto = new ProductDeliveryBillCreateDto();
            productDeliveryBillCreateDto.setDeliveryTime(new Date());
            productDeliveryBillCreateDto.setRelationShipmentOrderCode(dto.getDeliveryCode());
            if (OrderCategoryEnum.SALES_ORDER.getDictCode().equals(dto.getOrderCategory())) {
                productDeliveryBillCreateDto.setProductStockOperationType(ProductStockOperationType.SALE_DELIVER.name());
                productDeliveryBillCreateDto.setRelationShipmentOrderType(AssociatedDocumentsType.SALE.name());
                productDeliveryBillCreateDto.setType(StockType.PRODUCT.name());
            } else if (OrderCategoryEnum.MATERIAL_ORDER.getDictCode().equals(dto.getOrderCategory())) {
                productDeliveryBillCreateDto.setProductStockOperationType(ProductStockOperationType.MATERIAL_ORDER_DELIVER.name());
                productDeliveryBillCreateDto.setRelationShipmentOrderType(AssociatedDocumentsType.MATERIAL_STORE_PURCHASE.name());
                productDeliveryBillCreateDto.setType(StockType.MATERIAL.name());
            } else {
                Validate.isTrue((boolean)Boolean.FALSE, (String)"\u672a\u77e5\u8ba2\u5355\u7c7b\u522b\uff01", (Object[])new Object[0]);
            }
            ArrayList productDeliveryBillDetailDtoList = new ArrayList();
            itemDetailDtoList.forEach(deliveryDetailDto -> {
                productDeliveryBillCreateDto.setDeliveryWarehouseCode(deliveryDetailDto.getCurrentWarehouseCode());
                productDeliveryBillCreateDto.setDeliveryWarehouseName(deliveryDetailDto.getCurrentWarehouseName());
                ProductDeliveryBillDetailDto productDeliveryBillDetailDto = new ProductDeliveryBillDetailDto();
                productDeliveryBillDetailDto.setDeliveryWarehouseCode(deliveryDetailDto.getCurrentWarehouseCode());
                productDeliveryBillDetailDto.setDeliveryWarehouseName(deliveryDetailDto.getCurrentWarehouseName());
                productDeliveryBillDetailDto.setCustomerCode(deliveryDetailDto.getRelateCode());
                productDeliveryBillDetailDto.setCustomerName(deliveryDetailDto.getRelateName());
                productDeliveryBillDetailDto.setOrderCode(deliveryDetailDto.getOrderCode());
                productDeliveryBillDetailDto.setOrderItemCode(deliveryDetailDto.getOrderDetailCode());
                productDeliveryBillDetailDto.setItemType(deliveryDetailDto.getItemType());
                productDeliveryBillDetailDto.setProductCode(deliveryDetailDto.getGoodsCode());
                productDeliveryBillDetailDto.setProductName(deliveryDetailDto.getGoodsName());
                productDeliveryBillDetailDto.setProductUnit(deliveryDetailDto.getUnite());
                productDeliveryBillDetailDto.setProductSpec(deliveryDetailDto.getSpec());
                productDeliveryBillDetailDto.setDeliveryQuantity(deliveryDetailDto.getDeliveryQuantity());
                productDeliveryBillDetailDto.setCurrentQuantity(deliveryDetailDto.getDeliveryQuantity());
                productDeliveryBillDetailDto.setDeliveryOutQuantity(BigDecimal.ZERO);
                productDeliveryBillDetailDto.setDeliveryingQuantity(deliveryDetailDto.getDeliveryQuantity());
                productDeliveryBillDetailDto.setAddress(deliveryDetailDto.getDetailedAddress());
                productDeliveryBillDetailDto.setShipmentItemCode(deliveryDetailDto.getDeliveryDetailCode());
                productDeliveryBillDetailDto.setOrderType(deliveryDetailDto.getOrderType());
                productDeliveryBillDetailDto.setOriginalOrderCode(deliveryDetailDto.getOriginalOrderCode());
                productDeliveryBillDetailDtoList.add(productDeliveryBillDetailDto);
            });
            productDeliveryBillCreateDto.setDetailDtos(productDeliveryBillDetailDtoList);
            log.info("\u521b\u5efa\u53d1\u8d27\u5355{}\u5e76\u521b\u5efa\u51fa\u5e93\u5355{}", (Object)dto.getDeliveryCode(), (Object)JSON.toJSONString((Object)productDeliveryBillCreateDto));
            this.productDeliveryBillVoService.create(productDeliveryBillCreateDto);
        });
    }

    private void createValidation(DeliveryDto dto) {
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getOrderCategory(), (String)"\u8ba2\u5355\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (OrderCategoryEnum.SALES_ORDER.getDictCode().equals(dto.getOrderCategory())) {
            Validate.notBlank((CharSequence)dto.getRelateCode(), (String)"\u9009\u62e9\u9500\u552e\u8ba2\u5355\u65f6\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getRelateName(), (String)"\u9009\u62e9\u9500\u552e\u8ba2\u5355\u65f6\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Validate.notEmpty((Collection)dto.getDeliveryDetailDtoList(), (String)"\u53d1\u8d27\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

