/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.delivery.local.service.notifier;

import com.biz.crm.dms.business.delivery.sdk.service.DeliveryDetailVoService;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperationType;
import com.biz.crm.dms.business.psi.product.sdk.event.ProductDeliveryListener;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillVo;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProductDeliveryListenerImpl
implements ProductDeliveryListener {
    private static final Logger log = LoggerFactory.getLogger(ProductDeliveryListenerImpl.class);
    private final DeliveryDetailVoService deliveryDetailVoService;

    public ProductDeliveryListenerImpl(DeliveryDetailVoService deliveryDetailVoService) {
        this.deliveryDetailVoService = deliveryDetailVoService;
    }

    public void onCreate(ProductDeliveryBillVo billVo) {
        if (billVo == null || CollectionUtils.isEmpty((Collection)billVo.getDetailVos())) {
            return;
        }
        if (ProductStockOperationType.SALE_DELIVER.name().equals(billVo.getProductStockOperationType()) || ProductStockOperationType.MATERIAL_ORDER_DELIVER.name().equals(billVo.getProductStockOperationType())) {
            log.info("\u9500\u552e\u51fa\u5e93\u548c\u7269\u6599\u8ba2\u5355\u51fa\u5e93\u9700\u8981\u66f4\u65b0\u53d1\u8d27\u5355\u7684\u51fa\u5e93\u72b6\u6001\u53ca\u51fa\u5e93\u6570\u91cf\uff1a{}", (Object)billVo);
            billVo.getDetailVos().forEach(d -> this.deliveryDetailVoService.updateOutboundStatusByOutboundQuantity(billVo.getRelationShipmentOrderCode(), d.getShipmentItemCode(), d.getCurrentQuantity(), Boolean.valueOf(true)));
        }
    }
}

