package com.biz.crm.dms.business.delivery.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 发货单dto
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Data
@ApiModel(value = "DeliveryDto", description = "发货单dto")
public class DeliveryDto extends TenantFlagOpDto {

  /**
   * 发货单编码
   */
  @ApiModelProperty("发货单编码")
  private String deliveryCode;

  /**
   * 订单类别
   */
  @ApiModelProperty("订单类别")
  private String orderCategory;

  /**
   * 总发货数量
   */
  @ApiModelProperty("总发货数量")
  private BigDecimal totalDeliveryQuantity;

  /**
   * 总发货金额
   */
  @ApiModelProperty("总发货金额")
  private BigDecimal totalDeliverAmount;

  /**
   * 发货单明细行上该扣项目dto
   */
  @ApiModelProperty("发货单明细行上该扣项目dto")
  private List<DeliveryDetailDto> deliveryDetailDtoList;

  /**
   * 发货单附件dto
   */
  @ApiModelProperty("发货单附件dto")
  private List<DeliveryAttachmentDto> deliveryAttachmentDtoList;

  // 以下是搜索条件

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  private String relateName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 收货状态（1未收货;9完成）
   */
  @ApiModelProperty("收货状态（1未收货;9完成）")
  private String receiptStatus;

  /**
   * 出库状态
   */
  @ApiModelProperty("出库状态")
  private String outboundStatus;

  /**
   * 开票状态
   */
  @ApiModelProperty("开票状态")
  private String invoiceStatus;

  /**
   * 出库状态集合
   */
  @ApiModelProperty("出库状态集合")
  private List<String> outboundStatusList;

}

