package com.biz.crm.dms.business.delivery.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.Set;

/**
 * 发货单销量目标dto
 *
 * @author pengxi
 * @date 2022/04/06
 */
@Data
@ApiModel(value = "DeliverySalesTargetDto", description = "发货单销量目标dto")
public class DeliverySalesTargetDto extends TenantFlagOpDto {

  /**
   * 客户编码集合
   */
  @ApiModelProperty("客户编码集合")
  private Set<String> customerCodes;

  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  private Set<String> goodsCodes;

  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间")
  private Date startTime;

  /**
   * 结束时间
   */
  @ApiModelProperty("结束时间")
  private Date endTime;

}
