package com.biz.crm.dms.business.delivery.sdk.event;


import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryDto;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryVo;

import java.util.List;

/**
 * 发货单功能相关的事件通知
 * @author pengxi
 */
public interface DeliveryEventListener {

  /**
   * 当发货单信息被创建时，该事件被触发
   * @param deliveryDto
   */
  public void onCreated(DeliveryDto deliveryDto);

  /**
   * 当发货单信息被作废时，该事件被触发
   * @param deliveryVos
   */
  public void onDisabled(List<DeliveryVo> deliveryVos);
  
  /**
   * 当发货单信息被删除时（逻辑删除），该事件被触发
   * @param deliveryVos
   */
  public void onDeleted(List<DeliveryVo> deliveryVos);

  /**
   * 当发货单信息被收货时，该事件被触发
   * @param deliveryVos
   */
  public void onReceived(List<DeliveryVo> deliveryVos);
}