package com.biz.crm.dms.business.delivery.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryDto;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 发货单Vo服务接口类
 *
 * @author pengxi
 * @date 2022/02/16
 */
public interface DeliveryVoService {

  /**
   * 发货单分页查询
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<DeliveryVo> 普通授信分页信息
   */
  Page<DeliveryVo> findByConditions(Pageable pageable, DeliveryDto dto);

  /**
   * 根据ID获取发货单信息
   *
   * @param id 发货单ID
   * @return DeliveryVo 发货单信息
   */
  DeliveryVo findById(String id);

  /**
   * 创建
   *
   * @param dto
   */
  void create(DeliveryDto dto);

  /**
   * 创建发货单同时创建出库单
   *
   * @param dto
   */
  void createDeliveryAndOutbound(DeliveryDto dto);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用（作废）
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 收货
   *
   * @param ids
   */
  void receivingByIds(List<String> ids);

  /**
   * 根据订单号获取发货单信息
   *
   * @param orderCode 订单号
   * @return List<DeliveryVo> 发货单信息
   */
  List<DeliveryVo> findByOrderCode(String orderCode);
}
