package com.biz.crm.dms.business.delivery.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 新增发货单页面的订单未发货-vo
 *
 * @author pengxi
 */
@Data
@ApiModel(value = "DeliveryUnshippedVo", description = "新增发货单页面的订单未发货-vo")
public class DeliveryUnshippedVo {

  /**
   * 订单ID
   */
  @ApiModelProperty("订单ID")
  private String id;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  private String originalOrderCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

    /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

    /**
   * 订单状态
   */
  @ApiModelProperty("订单状态")
  private String orderStatus;

    /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  private String relateName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;


  /**
   * 订单总金额
   */
  @ApiModelProperty("订单总金额")
  private BigDecimal totalOrderAmount;

  /**
   * 本单实际支付 == 实际支付金额
   */
  @ApiModelProperty("本单实际支付 == 实际支付金额")
  private BigDecimal actualAmountPaid;

  /**
   * 商品数量
   */
  @ApiModelProperty("商品数量")
  private BigDecimal quantityOfCommodity;

  /**
   * 发货数量
   */
  @ApiModelProperty("发货数量")
  private BigDecimal deliveryQuantity;

  /**
   * 剩余可发货数量
   */
  @ApiModelProperty("剩余可发货数量")
  private BigDecimal residualDeliveryQuantity;

  /**
   * 下单时间
   */
  @ApiModelProperty("下单时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /**
   * 下单人
   */
  @ApiModelProperty("下单人")
  private String createName;

    /**
   * 期望到货时间
   */
  @ApiModelProperty("期望到货时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date expectedArrivalTime;

    /**
   * 收货地址 == 详细地址
   */
  @ApiModelProperty("收货地址 == 详细地址 ")
  private String detailedAddress;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  private String contactName;

  /**
   * 联系方式 == 联系电话
   */
  @ApiModelProperty("联系方式 == 联系电话")
  private String contactPhone;

    /**
   * 订单来源
   */
  @ApiModelProperty("订单来源")
  private String orderSource;


}
