package com.biz.crm.dms.business.delivery.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 发货单vo
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Data
@ApiModel(value = "DeliveryVo", description = "发货单vo")
public class DeliveryVo extends TenantFlagOpVo {

  /**
   * 发货单编码
   */
  @ApiModelProperty("发货单编码")
  private String deliveryCode;

  /**
   * 收货状态
   */
  @ApiModelProperty("收货状态")
  private String receiptStatus;

  /**
   * 订单类别
   */
  @ApiModelProperty("订单类别")
  private String orderCategory;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 总发货数量
   */
  @ApiModelProperty("总发货数量")
  private BigDecimal totalDeliveryQuantity;

  /**
   * 总发货金额
   */
  @ApiModelProperty("总发货金额")
  private BigDecimal totalDeliverAmount;

  // 以下是从订单查询的字段

  /**
   * 关联编码 【客户编码】（多个以','符合隔开）
   */
  @ApiModelProperty("关联编码 【客户编码】（多个以','符合隔开）")
  private String relateCodes;

  /**
   * 关联名称 【客户名称】（多个以','符合隔开）
   */
  @ApiModelProperty("关联名称 【客户名称】（多个以','符合隔开）")
  private String relateNames;

  /**
   * 组织编码（多个以','符合隔开）
   */
  @ApiModelProperty("组织编码（多个以','符合隔开）")
  private String orgCodes;

  /**
   * 组织名称（多个以','符合隔开）
   */
  @ApiModelProperty("组织名称（多个以','符合隔开）")
  private String orgNames;

  // 以下是从发货单明细查询的字段

  /**
   * 关联订单号（多个以','符合隔开）
   */
  @ApiModelProperty("关联订单号（多个以','符合隔开）")
  private String orderCodes;

  /**
   * 关联出库单（多个以','符合隔开）
   */
  @ApiModelProperty("关联出库单（多个以','符合隔开）")
  private String outboundCodes;

  /**
   * 出库状态（多个以','符合隔开）
   */
  @ApiModelProperty("出库状态（多个以','符合隔开）")
  private String outboundStatus;

  /**
   * 开票状态（多个以','符合隔开）
   */
  @ApiModelProperty("开票状态（多个以','符合隔开）")
  private String invoiceStatus;

  /**
   * 发货单明细vo
   */
  @ApiModelProperty("发货单明细vo")
  private List<DeliveryDetailVo> deliveryDetailVos;

  /**
   * 发货单附件vo
   */
  @ApiModelProperty("发货单附件vo")
  private List<DeliveryAttachmentVo> deliveryAttachmentVos;

}

