package com.biz.crm.dms.business.delivery.sdk.dto;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 发货单明细行上该扣项目dto
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Data
@ApiModel(value = "DeliveryDetailPayDto", description = "发货单明细行上该扣项目dto")
public class DeliveryDetailDeductDto extends TenantVo {

  /**
   * 发货单明细编码
   */
  @ApiModelProperty("发货单明细编码")
  private String deliveryDetailCode;

  /**
   * 发货单编码
   */
  @ApiModelProperty("发货单编码")
  private String deliveryCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单明细编码
   */
  @ApiModelProperty("订单明细编码")
  private String orderDetailCode;

  /**
   * 该扣项目组的key
   */
  @ApiModelProperty("该扣项目组的key")
  private String itemGroupKey;

  /**
   * 该扣项目key
   */
  @ApiModelProperty("该扣项目key")
  private String itemKey;

  /**
   * 该扣项目名称
   */
  @ApiModelProperty("该扣项目名称")
  private String itemName;

  /**
   * 该扣项目金额（分摊）
   */
  @ApiModelProperty("该扣项目金额（分摊）")
  private BigDecimal itemAmount;

  /**
   * 该扣项目金额数据的由来
   * 比如：【政策优惠】选择了的促销政策CODE
   */
  @ApiModelProperty("该扣项目金额数据的由来")
  private String originData;

  /**
   * 数据的由来【类型】
   * 比如：【政策优惠】的政策是整单的，还是行内商品的。
   */
  @ApiModelProperty("数据的由来【类型】")
  private String originDataType;
}
