package com.biz.crm.dms.business.delivery.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryDetailDeductVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 发货单明细dto
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Data
@ApiModel(value = "DeliveryDetailDto", description = "发货单明细dto")
public class DeliveryDetailDto extends TenantFlagOpDto {

  /**
   * 发货单编码
   */
  @ApiModelProperty("发货单编码")
  private String deliveryCode;

  /**
   * 发货单明细编码
   */
  @ApiModelProperty("发货单明细编码")
  private String deliveryDetailCode;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  private String originalOrderCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 订单：销售订单、物料订单
   */
  @ApiModelProperty("订单类别")
  private String orderCategory;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单明细编码
   */
  @ApiModelProperty("订单明细编码")
  private String orderDetailCode;

  /**
   * 发货数量
   */
  @ApiModelProperty("发货数量")
  private BigDecimal deliveryQuantity;

  /**
   * 收货数量
   */
  @ApiModelProperty("收货数量")
  private BigDecimal receivingQuantity;

  /**
   * 发货金额
   */
  @ApiModelProperty("发货金额")
  private BigDecimal deliverAmount;

  /**
   * 出库状态
   */
  @ApiModelProperty("出库状态")
  private String outboundStatus;

  /**
   * 出库数量
   */
  @ApiModelProperty("出库数量")
  private BigDecimal outboundQuantity;

  /**
   * 开票状态
   */
  @ApiModelProperty("开票状态")
  private String invoiceStatus;

  /**
   * 发货单明细行上该扣项目dto
   */
  @ApiModelProperty("发货单明细行上该扣项目dto")
  private List<DeliveryDetailDeductDto> deliveryDetailDeductDtoList;


  // 以下是从订单查询的字段 客户编码、客户名称、收货地址、联系人、联系方式、行项目类型、仓库、商品编码、商品名称、规格、单位、单价、数量、销售金额、实际支付金额
  // （行上该扣项目）

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  private String relateName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 收货地址 == 详细地址
   */
  @ApiModelProperty("收货地址 == 详细地址 ")
  private String detailedAddress;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  private String contactName;

  /**
   * 联系方式 == 联系电话
   */
  @ApiModelProperty("联系方式 == 联系电话")
  private String contactPhone;

  /**
   * 明细类型 == 行项目类型
   */
  @ApiModelProperty("明细类型 == 行项目类型")
  private String itemType;


  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  private String goodsCode;

  /**
   * 商品/物料名称
   */
  @ApiModelProperty("商品/物料名称")
  private String goodsName;

  /**
   * 历史仓库编码
   */
  @ApiModelProperty("历史仓库编码")
  private String historyWarehouseCode;

  /**
   * 历史仓库名称
   */
  @ApiModelProperty("历史仓库名称")
  private String historyWarehouseName;

  /**
   * 当前仓库编码
   */
  @ApiModelProperty("当前仓库编码")
  private String currentWarehouseCode;

  /**
   * 当前仓库名称
   */
  @ApiModelProperty("当前仓库名称")
  private String currentWarehouseName;

  /**
   * 成本单价 == 系统预设单价
   */
  @ApiModelProperty("成本单价 == 系统预设单价")
  private BigDecimal presetUnitPrice;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String unite;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  private BigDecimal quantity;

  /**
   * 销售金额
   */
  @ApiModelProperty("销售金额")
  private BigDecimal salesAmount;

  /**
   * 实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）
   */
  @ApiModelProperty("实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）")
  private BigDecimal finalPaymentAmount;

  /**
   * 订单明细行上该扣项目vo
   */
  @ApiModelProperty("订单明细行上该扣项目vo")
  private List<DeliveryDetailDeductVo> orderDetailDeductVos;
}
