package com.biz.crm.dms.business.delivery.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 新增发货单页面的订单未发货-dto
 *
 * @author pengxi
 * @date 2022/03/03
 */
@Data
@ApiModel(value = "DeliveryUnshippedPageDto", description = "新增发货单页面的订单未发货-dto")
public class DeliveryUnshippedPageDto extends TenantDto {

  /**
   * 订单类别
   */
  @ApiModelProperty("订单类别")
  private String orderCategory;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  private String relateName;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单编码集合
   */
  @ApiModelProperty("订单编码集合")
  private List<String> orderCodes;

  /**
   * 订单状态集合
   */
  @ApiModelProperty("订单状态集合")
  private List<String> orderStatus;

}

