package com.biz.crm.dms.business.delivery.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 出库状态枚举
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Getter
@AllArgsConstructor
public enum OutboundStatusEnum {
  /**
   * 出库状态枚举
   */
  START("1", "start", "待出库", "1"),
  PARTIAL("2", "partial", "部分出库", "2"),
  COMPLETE("9", "complete", "完全出库", "9"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static OutboundStatusEnum codeToEnum(String dictCode) {
    OutboundStatusEnum result = null;
    for (OutboundStatusEnum outboundStatusEnum : OutboundStatusEnum.values()) {
      if (outboundStatusEnum.dictCode.equals(dictCode)) {
        result = outboundStatusEnum;
      }
    }
    return result;
  }
}

