package com.biz.crm.dms.business.delivery.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryUnshippedVo;
import org.springframework.data.domain.Pageable;

/**
 * 查询没有发货完毕的订单信息
 * @author pengxi
 */
public interface DeliveryUnshippedVoService {

  /**
   * 查询没有发货完毕的订单信息 - 分页
   *
   * @param pageable 分页参数
   * @param orderUnshippedPageDto 新增发货单页面的订单未发货
   * @return Page<DeliveryUnshippedVo>
   */
  Page<DeliveryUnshippedVo> findByOrderUnshippedPageDto(Pageable pageable, DeliveryUnshippedPageDto orderUnshippedPageDto);
}
