package com.biz.crm.dms.business.delivery.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 发货单明细vo
 *
 * @author pengxi
 * @date 2022/02/16
 */
@Data
@ApiModel(value = "DeliveryDetailVo", description = "发货单明细vo")
public class DeliveryDetailVo extends TenantFlagOpVo {

  /**
   * 发货单编码
   */
  @ApiModelProperty("发货单编码")
  private String deliveryCode;

  /**
   * 发货单明细编码
   */
  @ApiModelProperty("发货单明细编码")
  private String deliveryDetailCode;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  private String originalOrderCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单明细编码
   */
  @ApiModelProperty("订单明细编码")
  private String orderDetailCode;

  /**
   * 出库单编码
   */
  @ApiModelProperty("出库单编码")
  private String outboundCode;

  /**
   * 出库状态
   */
  @ApiModelProperty("出库状态")
  private String outboundStatus;

  /**
   * 出库数量
   */
  @ApiModelProperty("出库数量")
  private BigDecimal outboundQuantity;

  /**
   * 开票状态
   */
  @ApiModelProperty("开票状态")
  private String invoiceStatus;

  /**
   * 发货数量
   */
  @ApiModelProperty("发货数量")
  private BigDecimal deliveryQuantity;

  /**
   * 收货数量
   */
  @ApiModelProperty("收货数量")
  private BigDecimal receivingQuantity;

  /**
   * 发货金额
   */
  @ApiModelProperty("发货金额")
  private BigDecimal deliverAmount;

  /**
   * 发货单明细行上该扣项目vo
   */
  @ApiModelProperty("发货单明细行上该扣项目vo")
  private List<DeliveryDetailDeductVo> deliveryDetailDeductVos;

  // 以下是从订单查询的字段 客户编码、客户名称、收货地址、联系人、联系方式、行项目类型、仓库、商品编码、商品名称、规格、单位、单价、数量、销售金额、实际支付金额
  // （行上该扣项目）

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  private String relateName;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 收货地址 == 详细地址
   */
  @ApiModelProperty("收货地址 == 详细地址 ")
  private String detailedAddress;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  private String contactName;

  /**
   * 联系方式 == 联系电话
   */
  @ApiModelProperty("联系方式 == 联系电话")
  private String contactPhone;

  /**
   * 提货方式
   */
  @ApiModelProperty("提货方式")
  private String pickUpWay;

  /**
   * 明细类型 == 行项目类型
   */
  @ApiModelProperty("明细类型 == 行项目类型")
  private String itemType;

  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  private String goodsCode;

  /**
   * 商品/物料名称
   */
  @ApiModelProperty("商品/物料名称")
  private String goodsName;

  /**
   * 历史仓库编码
   */
  @ApiModelProperty("历史仓库编码")
  private String historyWarehouseCode;

  /**
   * 历史仓库名称
   */
  @ApiModelProperty("历史仓库名称")
  private String historyWarehouseName;

  /**
   * 当前仓库编码
   */
  @ApiModelProperty("当前仓库编码")
  private String currentWarehouseCode;

  /**
   * 当前仓库名称
   */
  @ApiModelProperty("当前仓库名称")
  private String currentWarehouseName;

  /**
   * 全部库存（实际库存量）
   */
  @ApiModelProperty("全部库存（实际库存量）")
  private BigDecimal totalStock;

  /**
   * 可用库存
   */
  @ApiModelProperty("可用库存")
  private BigDecimal availableStock;

  /**
   * 占用数量
   */
  @ApiModelProperty("占用数量")
  private BigDecimal frozenQuantity;

  /**
   * 最大可发货数量（订单数量-已发货数量）
   */
  @ApiModelProperty("最大可发货数量（订单数量-已发货数量）")
  private BigDecimal maxAvailableStock;

  /**
   * 成本单价 == 系统预设单价
   */
  @ApiModelProperty("成本单价 == 系统预设单价")
  private BigDecimal presetUnitPrice;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String unite;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  private BigDecimal quantity;

  /**
   * 销售金额
   */
  @ApiModelProperty("销售金额")
  private BigDecimal salesAmount;

  /**
   * 本次已发销售金额
   */
  @ApiModelProperty("本次已发销售金额")
  private BigDecimal deliverSalesAmount;

  /**
   * 实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）
   */
  @ApiModelProperty("实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）")
  private BigDecimal shouldPaymentAmount;

  /**
   * 本次已发实际支付金额
   */
  @ApiModelProperty("本次已发实际支付金额")
  private BigDecimal deliverShouldPaymentAmount;

  /**
   * 订单明细行上该扣项目vo
   */
  @ApiModelProperty("订单明细行上该扣项目vo")
  private List<DeliveryDetailDeductVo> orderDetailDeductVos;

  /**
   * 商品图片信息
   */
  @ApiModelProperty("附件信息，图片信息")
  private List<ProductMediaVo> pictureMediaList;
}

