package com.biz.crm.dms.business.exchange.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeFlowService;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 换货单资源类业务控制层
 *
 * @author xi.peng
 * @since 2022-07-06 19:00:33
 */
@Slf4j
@Api(tags = "换货单资源类业务控制层")
@RestController
@RequestMapping(value = {"/v1/exchange/exchangeFlow"})
public class ExchangeFlowController {

  @Autowired
  private ExchangeFlowService exchangeFlowService;

  @ApiOperation(value = "提交")
  @PostMapping(value = "submit")
  public Result submit(@RequestBody ExchangeDto dto) {
    try {
      this.exchangeFlowService.submit(dto);
      return Result.ok("提交成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
