package com.biz.crm.dms.business.exchange.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangePageDto;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;

/**
 * 换货单主表实体(DmsOrderExchange)表控制层
 *
 * @author xi.peng
 * @since 2022-07-06 19:00:33
 */
@Slf4j
@Api(tags = "换货单主表实体：ExchangeVo")
@RestController
@RequestMapping(value = {"/v1/exchange/exchangeVo"})
public class ExchangeVoController {

  @Autowired
  private ExchangeVoService exchangeVoService;

  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ExchangeVo>> findByConditions(@PageableDefault(50) Pageable pageable, ExchangePageDto dto) {
    try {
      Page<ExchangeVo> result = this.exchangeVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<ExchangeVo> findDetailById(@RequestParam("id") String id) {
    try {
      ExchangeVo vo = this.exchangeVoService.findDetailById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "暂存")
  @PostMapping(value = "draft")
  public Result draft(@RequestBody ExchangeDto dto) {
    try {
      this.exchangeVoService.draft(dto);
      return Result.ok("暂存成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.exchangeVoService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "计算差额")
  @PostMapping(value = "difference")
  public Result<ExchangeVo> difference(@RequestBody ExchangeDto dto) {
    try {
      ExchangeVo exchangeVo = this.exchangeVoService.difference(dto);
      return Result.ok(exchangeVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
