package com.biz.crm.dms.business.exchange.local.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 换货单差额子表(DmsOrderExchangeDifference)实体类
 *
 * @author sunx
 * @since 2022-07-06 19:00:34
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "dms_exchange_difference")
@TableName(value = "dms_exchange_difference")
@ApiModel(value = "ExchangeDifference", description = "换货单差额子表")
@org.hibernate.annotations.Table(appliesTo = "dms_exchange_difference", comment = "换货单差额子表")
public class ExchangeDifferenceEntity extends TenantFlagOpEntity {

  @ApiModelProperty("换货单编码")
  @TableField(value = "exchange_code")
  @Column(name = "exchange_code", length = 64, columnDefinition = "varchar(64) COMMENT '换货单编码'")
  private String exchangeCode;

  @ApiModelProperty("池子类型")
  @TableField(value = "pool_type")
  @Column(name = "pool_type", length = 64, columnDefinition = "varchar(64) COMMENT '池子类型'")
  private String poolType;

  @ApiModelProperty("指导在池子方的操作（金额正上账，负使用）")
  @TableField(value = "pool_guide")
  @Column(name = "pool_guide", length = 64, columnDefinition = "varchar(64) COMMENT '指导在池子方的操作（金额正上账，负使用）'")
  private String poolGuide;

  @ApiModelProperty("来源编码")
  @TableField(value = "source_code")
  @Column(name = "source_code", length = 64, columnDefinition = "varchar(64) COMMENT '来源编码'")
  private String sourceCode;

  @ApiModelProperty("来源绑定信息")
  @TableField(value = "source_bind")
  @Column(name = "source_bind", length = 64, columnDefinition = "varchar(64) COMMENT '来源绑定信息'")
  private String sourceBind;

  @ApiModelProperty("金额(元)")
  @TableField(value = "exchange_amount")
  @Column(name = "exchange_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '金额(元)'")
  private BigDecimal exchangeAmount;

}
