package com.biz.crm.dms.business.exchange.local.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 换货单主表实体(DmsOrderExchange)实体类
 *
 * @author sunx
 * @since 2022-07-06 19:00:23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "dms_exchange")
@TableName(value = "dms_exchange")
@ApiModel(value = "DmsExchange", description = "换货单主表实体")
@org.hibernate.annotations.Table(appliesTo = "dms_exchange", comment = "换货单主表实体")
public class ExchangeEntity extends TenantFlagOpEntity {

  @ApiModelProperty("暂存的草稿（0：否；1：是）")
  @Column(name = "draft", length = 1, columnDefinition = "bit(1) COMMENT '暂存的草稿（0：否；1：是）'")
  private Boolean draft;

  @ApiModelProperty("原订单编号")
  @TableField(value = "original_order_code")
  @Column(name = "original_order_code", length = 64, columnDefinition = "varchar(64) COMMENT '原订单编号'")
  private String originalOrderCode;

  @ApiModelProperty("原订单ID")
  @TableField(value = "original_order_id")
  @Column(name = "original_order_id", length = 64, columnDefinition = "varchar(64) COMMENT '原订单ID'")
  private String originalOrderId;

  @ApiModelProperty("产生的订单编号")
  @TableField(value = "produce_order_code")
  @Column(name = "produce_order_code", length = 64, columnDefinition = "varchar(64) COMMENT '产生的订单编号'")
  private String produceOrderCode;

  @ApiModelProperty("产生的订单ID")
  @TableField(value = "produce_order_id")
  @Column(name = "produce_order_id", length = 64, columnDefinition = "varchar(64) COMMENT '产生的订单ID'")
  private String produceOrderId;

  @ApiModelProperty("产生的退货订单编号")
  @TableField(value = "produce_return_code")
  @Column(name = "produce_return_code", length = 64, columnDefinition = "varchar(64) COMMENT '产生的退货订单编号'")
  private String produceReturnCode;

  @ApiModelProperty("产生的退货订单ID")
  @TableField(value = "produce_return_id")
  @Column(name = "produce_return_id", length = 64, columnDefinition = "varchar(64) COMMENT '产生的退货订单ID'")
  private String produceReturnId;

  @ApiModelProperty("换货单编码")
  @TableField(value = "exchange_code")
  @Column(name = "exchange_code", length = 64, columnDefinition = "varchar(64) COMMENT '换货单编码'")
  private String exchangeCode;

  @ApiModelProperty("换货单来源")
  @TableField(value = "exchange_source")
  @Column(name = "exchange_source", length = 32, columnDefinition = "varchar(32) COMMENT '换货单来源'")
  private String exchangeSource;

  @ApiModelProperty("换货单状态")
  @TableField(value = "exchange_status")
  @Column(name = "exchange_status", length = 32, columnDefinition = "varchar(32) COMMENT '换货单状态'")
  private String exchangeStatus;

  @ApiModelProperty("换货类型")
  @TableField(value = "exchange_type")
  @Column(name = "exchange_type", length = 32, columnDefinition = "varchar(32) COMMENT '换货类型'")
  private String exchangeType;

  @ApiModelProperty("换货时间")
  @TableField(value = "exchange_time")
  @Column(name = "exchange_time", length = -1, columnDefinition = "datetime COMMENT '换货时间'")
  private Date exchangeTime;

  @ApiModelProperty("换货金额(元)")
  @TableField(value = "exchange_amount")
  @Column(name = "exchange_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '换货金额(元)'")
  private BigDecimal exchangeAmount;

  @ApiModelProperty("换货数量")
  @TableField(value = "exchange_quantity")
  @Column(name = "exchange_quantity", length = 20, columnDefinition = "decimal(20,4) COMMENT '换货数量'")
  private BigDecimal exchangeQuantity;

  @ApiModelProperty("退货金额(元)")
  @TableField(value = "return_amount")
  @Column(name = "return_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '退货金额(元)'")
  private BigDecimal returnAmount;

  @ApiModelProperty("退货数量")
  @TableField(value = "return_quantity")
  @Column(name = "return_quantity", length = 20, columnDefinition = "decimal(20,4) COMMENT '退货数量'")
  private BigDecimal returnQuantity;

  @ApiModelProperty("差额(元)")
  @TableField(value = "difference_amount")
  @Column(name = "difference_amount", length = 20, columnDefinition = "decimal(20,4) COMMENT '差额(元)'")
  private BigDecimal differenceAmount;

  @ApiModelProperty("换货原因")
  @TableField(value = "reason")
  @Column(name = "reason", length = 128, columnDefinition = "varchar(128) COMMENT '换货原因'")
  private String reason;

  @ApiModelProperty("客户编码")
  @TableField(value = "customer_code")
  @Column(name = "customer_code", length = 64, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String customerCode;

  @ApiModelProperty("客户名称")
  @TableField(value = "customer_name")
  @Column(name = "customer_name", length = 128, columnDefinition = "varchar(128) COMMENT '客户名称'")
  private String customerName;

  @ApiModelProperty("审批流程编码")
  @TableField(value = "process_key")
  @Column(name = "process_key", length = 64, columnDefinition = "varchar(64) COMMENT '审批流程编码'")
  private String processKey;

  @ApiModelProperty("审批单号")
  @TableField(value = "process_number")
  @Column(name = "process_number", length = 64, columnDefinition = "varchar(64) COMMENT '审批单号'")
  private String processNumber;

  @ApiModelProperty("审批备注")
  @TableField(value = "process_remark")
  @Column(name = "process_remark", length = 200, columnDefinition = "varchar(200) COMMENT '审批备注'")
  private String processRemark;

  @ApiModelProperty("审批状态")
  @TableField(value = "process_status")
  @Column(name = "process_status", length = -1, columnDefinition = "int COMMENT '审批状态'")
  private Integer processStatus;

}
