package com.biz.crm.dms.business.exchange.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 换货单附件子表(DmsOrderExchangeFile)实体类
 *
 * @author sunx
 * @since 2022-07-06 19:00:33
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "dms_exchange_file")
@TableName(value = "dms_exchange_file")
@ApiModel(value = "DmsExchangeFile", description = "换货单附件子表")
@org.hibernate.annotations.Table(appliesTo = "dms_exchange_file", comment = "换货单附件子表")
public class ExchangeFileEntity extends TenantFlagOpEntity {

  @ApiModelProperty("文件名")
  @TableField(value = "file_name")
  @Column(name = "file_name", length = 128, columnDefinition = "varchar(128) COMMENT '文件名'")
  private String fileName;

  @ApiModelProperty("文件唯一标识")
  @TableField(value = "object_name")
  @Column(name = "object_name", length = 200, columnDefinition = "varchar(200) COMMENT '文件唯一标识'")
  private String objectName;

  @ApiModelProperty("换货单编码")
  @TableField(value = "exchange_code")
  @Column(name = "exchange_code", length = 64, columnDefinition = "varchar(64) COMMENT '换货单编码'")
  private String exchangeCode;

  @ApiModelProperty("文件全路径")
  @TableField(value = "url")
  @Column(name = "url", length = 200, columnDefinition = "varchar(200) COMMENT '文件全路径'")
  private String url;

  @ApiModelProperty("文件路径")
  @TableField(value = "url_path")
  @Column(name = "url_path", length = 200, columnDefinition = "varchar(200) COMMENT '文件路径'")
  private String urlPath;

  @ApiModelProperty("域名")
  @TableField(value = "url_path_prefix")
  @Column(name = "url_path_prefix", length = 128, columnDefinition = "varchar(128) COMMENT '域名'")
  private String urlPathPrefix;

}
