package com.biz.crm.dms.business.exchange.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.exchange.local.entity.ExchangeEntity;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangePageDto;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import org.apache.ibatis.annotations.Param;

/**
 * 换货单主表实体(DmsOrderExchange)表数据库访问层
 *
 * @author xi.peng
 * @since 2022-07-06 19:00:29
 */
public interface ExchangeMapper extends BaseMapper<ExchangeEntity> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<ExchangeVo> findByConditions(Page<ExchangePageDto> page, @Param("dto") ExchangePageDto dto);

}

